/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.config;

import games.enchanted.eg_text_customiser.common.Logging;
import games.enchanted.eg_text_customiser.common.config.ConfigValues;
import java.net.URI;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class ConfigScreen
extends Screen {
    private static final Component TITLE = Component.translatableWithFallback((String)"gui.eg_text_customiser.config.title", (String)"Text Customiser Config").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final String TOGGLE_DEBUG_LOGS_KEY = "gui.eg_text_customiser.button.debug_logs";
    private static final Component DEBUG_LOGS_TOGGLED_ON = Component.translatable((String)"gui.eg_text_customiser.button.debug_logs", (Object[])new Object[]{CommonComponents.OPTION_ON});
    private static final Component DEBUG_LOGS_TOGGLED_OFF = Component.translatable((String)"gui.eg_text_customiser.button.debug_logs", (Object[])new Object[]{CommonComponents.OPTION_OFF});
    private static final String TOGGLE_MOD = "gui.eg_text_customiser.button.toggle_mod";
    private static final Component MOD_TOGGLED_ON = Component.translatable((String)"gui.eg_text_customiser.button.toggle_mod", (Object[])new Object[]{CommonComponents.OPTION_ON});
    private static final Component MOD_TOGGLED_OFF = Component.translatable((String)"gui.eg_text_customiser.button.toggle_mod", (Object[])new Object[]{CommonComponents.OPTION_OFF});
    private static final String WIKI_LINK_KEY = "gui.eg_text_customiser.button.wiki_link";
    private static final Component WIKI_LINK = Component.translatableWithFallback((String)"gui.eg_text_customiser.button.wiki_link", (String)"Read the Wiki");
    private final HeaderAndFooterLayout headerAndFooterLayout = new HeaderAndFooterLayout((Screen)this);
    private final LinearLayout contentsFlow = LinearLayout.vertical().spacing(8);
    private final Screen parent;

    protected ConfigScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.headerAndFooterLayout.addTitleHeader(TITLE, this.font);
        this.headerAndFooterLayout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, widget -> this.onClose()).width(200).build());
        this.contentsFlow.setY(64);
        this.addConfigOptions();
        this.headerAndFooterLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.contentsFlow.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addConfigOptions() {
        this.contentsFlow.addChild((LayoutElement)Button.builder((Component)ConfigScreen.getToggledComponent(DEBUG_LOGS_TOGGLED_ON, DEBUG_LOGS_TOGGLED_OFF, ConfigValues.TEXT_DEBUG_LOGS), widget -> {
            widget.setMessage(ConfigScreen.getToggledComponent(DEBUG_LOGS_TOGGLED_ON, DEBUG_LOGS_TOGGLED_OFF, !ConfigValues.TEXT_DEBUG_LOGS));
            ConfigValues.TEXT_DEBUG_LOGS = !ConfigValues.TEXT_DEBUG_LOGS;
            Logging.info("Text style logging turned {}", ConfigValues.TEXT_DEBUG_LOGS ? "on" : "off");
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.eg_text_customiser.button.debug_logs.tooltip"))).bounds(this.width / 2 - 100, this.height / 2 - 20 - 24, 200, 20).build());
        this.contentsFlow.addChild((LayoutElement)Button.builder((Component)ConfigScreen.getToggledComponent(MOD_TOGGLED_ON, MOD_TOGGLED_OFF, ConfigValues.DISABLE_MOD), widget -> {
            widget.setMessage(ConfigScreen.getToggledComponent(MOD_TOGGLED_ON, MOD_TOGGLED_OFF, !ConfigValues.DISABLE_MOD));
            ConfigValues.DISABLE_MOD = !ConfigValues.DISABLE_MOD;
            Logging.info("Text replacement turned {}", ConfigValues.DISABLE_MOD ? "on" : "off");
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.eg_text_customiser.button.toggle_mod.tooltip"))).bounds(this.width / 2 - 100, this.height / 2 - 20 - 24, 200, 20).build());
        this.contentsFlow.addChild((LayoutElement)Button.builder((Component)WIKI_LINK, (Button.OnPress)ConfirmLinkScreen.confirmLink((Screen)this, (URI)URI.create("https://github.com/Enchanted-Games/text-customiser/wiki"), (boolean)false)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.eg_text_customiser.button.wiki_link.tooltip"))).bounds(this.width / 2 - 100, this.height / 2 - 20, 200, 20).build());
        this.repositionElements();
    }

    public static Component getToggledComponent(Component first, Component second, boolean toggle) {
        return toggle ? first : second;
    }

    protected void repositionElements() {
        this.headerAndFooterLayout.arrangeElements();
        this.contentsFlow.setX(this.width / 2 - this.contentsFlow.getWidth() / 2);
        this.contentsFlow.arrangeElements();
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public static Screen createConfigScreen(Screen parent) {
        return new ConfigScreen(parent);
    }
}

