/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.fake_style;

import games.enchanted.eg_text_customiser.common.fake_style.DecorationType;
import games.enchanted.eg_text_customiser.common.fake_style.SpecialTextColour;
import games.enchanted.eg_text_customiser.common.pack.colour_override.ColourOverrideDefinition;
import games.enchanted.eg_text_customiser.common.util.ColourUtil;
import java.util.Objects;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FakeStyle(@Nullable SpecialTextColour colour, @Nullable Integer shadowColour, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable FontDescription font, @Nullable DecorationType decorationType, @Nullable Integer codepoint, ColourOverrideDefinition.PropertiesPart properties) {
    public FakeStyle(@Nullable SpecialTextColour colour, @Nullable Integer shadowColour, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable FontDescription font, @Nullable DecorationType decorationType, @Nullable Integer codepoint) {
        this(colour, shadowColour, bold, italic, underlined, strikethrough, obfuscated, font, decorationType, codepoint, ColourOverrideDefinition.PropertiesPart.DEFAULT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        SpecialTextColour colour1;
        Object object;
        if (!(o instanceof FakeStyle)) return false;
        FakeStyle fakeStyle = (FakeStyle)o;
        try {
            object = fakeStyle.colour();
            colour1 = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object shadowColour1 = object = fakeStyle.shadowColour();
        Object bold1 = object = fakeStyle.bold();
        Object italic1 = object = fakeStyle.italic();
        Object underlined1 = object = fakeStyle.underlined();
        Object strikethrough1 = object = fakeStyle.strikethrough();
        Object obfuscated1 = object = fakeStyle.obfuscated();
        Object font1 = object = fakeStyle.font();
        Object type = object = fakeStyle.decorationType();
        Object codepoint1 = object = fakeStyle.codepoint();
        Object properties1 = object = fakeStyle.properties();
        if (!Objects.equals(this.bold, bold1)) return false;
        if (!Objects.equals(this.italic, italic1)) return false;
        if (!Objects.equals(this.underlined, underlined1)) return false;
        if (!Objects.equals(this.obfuscated, obfuscated1)) return false;
        if (!Objects.equals(this.shadowColour, shadowColour1)) return false;
        if (!Objects.equals(this.strikethrough, strikethrough1)) return false;
        if (!Objects.equals(this.font, font1)) return false;
        if (!Objects.equals(this.colour, colour1)) return false;
        if (!Objects.equals((Object)this.decorationType, type)) return false;
        if (!Objects.equals(this.codepoint, codepoint1)) return false;
        if (!Objects.equals(this.properties, properties1)) return false;
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return "FakeStyle{colour=" + String.valueOf(this.colour) + ", shadowColour=" + this.shadowColour + ", bold=" + this.bold + ", italic=" + this.italic + ", underlined=" + this.underlined + ", strikethrough=" + this.strikethrough + ", obfuscated=" + this.obfuscated + ", font=" + String.valueOf(this.font) + ", decorationType=" + String.valueOf((Object)this.decorationType) + ", codepoint=" + this.codepoint + ", properties=" + String.valueOf(this.properties) + "}";
    }

    @NotNull
    public String formattedString() {
        return "[" + (String)(this.colour == null ? "" : "color=\"" + this.colour.formattedString() + "\"") + (String)(this.shadowColour == null ? "" : ", shadow_color=\"" + ColourUtil.formatIntAsHexString(this.shadowColour) + "\"") + (String)(this.bold == null ? "" : ", bold=" + this.bold) + (String)(this.italic == null ? "" : ", italic=" + this.italic) + (String)(this.underlined == null ? "" : ", underlined=" + this.underlined) + (String)(this.strikethrough == null ? "" : ", strikethrough=" + this.strikethrough) + (String)(this.obfuscated == null ? "" : ", obfuscated=" + this.obfuscated) + (String)(this.font == null ? "" : ", font=" + FakeStyle.formatFontDescription(this.font)) + (String)(this.decorationType == null ? "" : ", decoration_type=\"" + String.valueOf((Object)this.decorationType) + "\"") + (String)(this.codepoint == null ? "" : ", character=[codepoint=" + this.codepoint + ", char=" + (char)this.codepoint.intValue() + "]") + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String formatFontDescription(FontDescription font) {
        boolean bl;
        ResolvableProfile profile;
        if (font instanceof FontDescription.Resource) {
            ResourceLocation resourceLocation;
            FontDescription.Resource resource = (FontDescription.Resource)font;
            ResourceLocation id = resourceLocation = resource.id();
            return "\"" + String.valueOf(id) + "\"";
        }
        if (font instanceof FontDescription.AtlasSprite) {
            ResourceLocation resourceLocation;
            FontDescription.AtlasSprite atlasSprite = (FontDescription.AtlasSprite)font;
            ResourceLocation atlasId = resourceLocation = atlasSprite.atlasId();
            ResourceLocation spriteId = resourceLocation = atlasSprite.spriteId();
            return "[type=atlas_sprite, atlas\"" + String.valueOf(atlasId) + "\", sprite\"" + String.valueOf(spriteId) + "\"]";
        }
        if (!(font instanceof FontDescription.PlayerSprite)) return "unknown";
        FontDescription.PlayerSprite playerSprite = (FontDescription.PlayerSprite)font;
        try {
            ResolvableProfile resolvableProfile;
            profile = resolvableProfile = playerSprite.profile();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        boolean hat = bl = playerSprite.hat();
        return "[type=profile, name\"" + profile.name().orElse("<none>") + "\", hat\"" + hat + "\"]";
    }
}

