/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.fake_style;

import com.mojang.datafixers.util.Either;
import games.enchanted.eg_text_customiser.common.fake_style.SignTextData;
import games.enchanted.eg_text_customiser.common.mixin.accessor.TextColorAccess;
import games.enchanted.eg_text_customiser.common.util.ColourUtil;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecialTextColour {
    private static final int WHITE = 0xFFFFFF;
    private final Either<Integer, String> colourValueOrName;
    private final boolean isSignText;
    private final boolean isGlowingSignText;
    private final boolean isGlowingOutline;
    @Nullable
    private final DyeColor dyeColor;

    public SpecialTextColour(int rgb) {
        if (rgb == -1) {
            rgb = 0xFFFFFF;
        }
        this.colourValueOrName = Either.left((Object)rgb);
        this.isSignText = false;
        this.isGlowingSignText = false;
        this.isGlowingOutline = false;
        this.dyeColor = null;
    }

    public SpecialTextColour(String colourName) {
        this.colourValueOrName = Either.right((Object)colourName);
        this.isSignText = false;
        this.isGlowingSignText = false;
        this.isGlowingOutline = false;
        this.dyeColor = null;
    }

    public SpecialTextColour(int rgb, @NotNull DyeColor dyeColor, boolean isSignText, boolean isGlowingSignText, boolean isGlowingOutline) {
        this.colourValueOrName = Either.left((Object)rgb);
        this.isSignText = isSignText;
        this.isGlowingSignText = isGlowingSignText;
        this.isGlowingOutline = isGlowingOutline;
        this.dyeColor = dyeColor;
    }

    public static SpecialTextColour fromTextColor(@Nullable TextColor textColor) {
        if (textColor == null) {
            return new SpecialTextColour(0xFFFFFF);
        }
        String textNamedColour = ((TextColorAccess)textColor).eg_text_customiser$getName();
        if (textNamedColour != null) {
            return new SpecialTextColour(textNamedColour);
        }
        return new SpecialTextColour(textColor.getValue());
    }

    public static SpecialTextColour fromSignTextData(SignTextData signTextData, boolean isGlowingOutline) {
        if (isGlowingOutline && signTextData.outlineColour() == null) {
            throw new IllegalStateException("SignTextData has no outline colour but tried to create a SpecialTextColour for outline colour");
        }
        return new SpecialTextColour(isGlowingOutline ? signTextData.outlineColour().intValue() : signTextData.darkColour(), signTextData.dyeColor(), true, signTextData.isGlowingSignText(), isGlowingOutline);
    }

    public static SpecialTextColour fromEither(Either<Integer, String> either) {
        if (either.left().isPresent()) {
            return new SpecialTextColour((Integer)either.left().get());
        }
        if (either.right().isEmpty()) {
            throw new IllegalStateException("Either passed with no right or left value");
        }
        return new SpecialTextColour((String)either.right().get());
    }

    public Either<Integer, String> getColourValueOrName() {
        return this.colourValueOrName;
    }

    public int safeGetAsRGB() {
        return SpecialTextColour.safeGetAsRGB(this.colourValueOrName);
    }

    private static int safeGetAsRGB(Either<Integer, String> colourValueOrName) {
        if (colourValueOrName.left().isPresent()) {
            return (Integer)colourValueOrName.left().get();
        }
        if (colourValueOrName.right().isEmpty()) {
            throw new IllegalStateException("Either has no right or left value");
        }
        ChatFormatting formatting = ChatFormatting.getByName((String)((String)colourValueOrName.right().get()));
        if (formatting != null && formatting.isColor() && formatting.getColor() != null) {
            return formatting.getColor();
        }
        throw new IllegalStateException("Expected a colour chat formatting, got '" + String.valueOf(formatting) + "' instead.");
    }

    @Nullable
    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public boolean isNamedColour() {
        return this.colourValueOrName.right().isPresent();
    }

    private boolean compareColour(Either<Integer, String> comparison, boolean matchNamed) {
        if (matchNamed) {
            return Objects.equals(this.safeGetAsRGB(), SpecialTextColour.safeGetAsRGB(comparison));
        }
        if (this.colourValueOrName.left().isPresent() && comparison.left().isPresent()) {
            return Objects.equals(this.colourValueOrName.left(), comparison.left());
        }
        if (this.colourValueOrName.right().isPresent() && comparison.right().isPresent()) {
            return Objects.equals(this.colourValueOrName.right(), comparison.right());
        }
        return false;
    }

    public boolean compareTo(SpecialTextColour comparison, boolean matchNamed) {
        if (this.isSignText && comparison.isSignText) {
            return Objects.equals(this.dyeColor, comparison.dyeColor) && this.isGlowingSignText == comparison.isGlowingSignText && this.isGlowingOutline == comparison.isGlowingOutline;
        }
        return this.isSignText == comparison.isSignText && this.isGlowingSignText == comparison.isGlowingSignText && this.isGlowingOutline == comparison.isGlowingOutline && this.compareColour(comparison.colourValueOrName, matchNamed);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecialTextColour that = (SpecialTextColour)o;
        return this.compareTo(that, true);
    }

    public int hashCode() {
        return Objects.hash(this.colourValueOrName, this.isSignText, this.isGlowingSignText, this.isGlowingOutline);
    }

    @NotNull
    public String toString() {
        return "SpecialTextColour{colourValueOrName=" + String.valueOf(this.colourValueOrName) + ", isSignText=" + this.isSignText + ", isGlowingSignText=" + this.isGlowingSignText + ", isGlowingOutline=" + this.isGlowingOutline + ", dyeColor=" + String.valueOf(this.dyeColor) + "}";
    }

    public String formattedString() {
        if (this.isSignText) {
            return "{dye=" + (this.dyeColor == null ? "<null>" : this.dyeColor.getName()) + ", glowing=" + this.isGlowingSignText + ", is_glowing_outline=" + this.isGlowingOutline + "}";
        }
        if (this.colourValueOrName.left().isPresent()) {
            return ColourUtil.formatIntAsHexString((Integer)this.colourValueOrName.left().get());
        }
        if (this.colourValueOrName.right().isPresent()) {
            return (String)this.colourValueOrName.right().get();
        }
        return this.toString();
    }
}

