/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.colour_override;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_text_customiser.common.Logging;
import games.enchanted.eg_text_customiser.common.fake_style.DecorationType;
import games.enchanted.eg_text_customiser.common.fake_style.FakeStyle;
import games.enchanted.eg_text_customiser.common.fake_style.SpecialTextColour;
import games.enchanted.eg_text_customiser.common.pack.property_tests.CharacterPredicateTest;
import games.enchanted.eg_text_customiser.common.pack.property_tests.ColourPredicateTest;
import games.enchanted.eg_text_customiser.common.pack.property_tests.FontPredicateTest;
import games.enchanted.eg_text_customiser.common.pack.property_tests.SimpleEqualityTest;
import games.enchanted.eg_text_customiser.common.pack.property_tests.character.CharacterPredicates;
import games.enchanted.eg_text_customiser.common.pack.property_tests.character.predicates.CharacterPredicate;
import games.enchanted.eg_text_customiser.common.pack.property_tests.colour.ColourPredicates;
import games.enchanted.eg_text_customiser.common.pack.property_tests.colour.predicates.BasicColourPredicate;
import games.enchanted.eg_text_customiser.common.pack.property_tests.colour.predicates.ColourPredicate;
import games.enchanted.eg_text_customiser.common.pack.property_tests.font.FontPredicates;
import games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates.FontPredicate;
import games.enchanted.eg_text_customiser.common.serialization.ColourCodecs;
import games.enchanted.eg_text_customiser.common.serialization.ModCodecs;
import games.enchanted.eg_text_customiser.common.util.Profiling;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public class ColourOverrideDefinition {
    public static final Codec<List<ColourPredicate>> COLOUR_PREDICATE_LIST_CODEC = ModCodecs.singleOrListCodec(ColourPredicates.CODEC);
    public static final Codec<List<FontPredicate>> FONT_PREDICATE_LIST_CODEC = ModCodecs.singleOrListCodec(FontPredicates.CODEC);
    public static final Codec<List<DecorationType>> DECORATION_TYPE_LIST_CODEC = ModCodecs.singleOrListCodec(StringRepresentable.fromEnum(DecorationType::values));
    public static final Codec<List<CharacterPredicate>> CHARACTER_PREDICATE_LIST_CODEC = ModCodecs.singleOrListCodec(CharacterPredicates.CODEC);
    public static final Codec<ColourOverrideDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PropertiesPart.CODEC.optionalFieldOf("properties", (Object)PropertiesPart.DEFAULT).forGetter(override -> override.properties), (App)WhenPart.CODEC.fieldOf("when").forGetter(override -> override.when), (App)ReplaceWithPart.CODEC.fieldOf("replace_with").forGetter(override -> override.replacement)).apply((Applicative)instance, ColourOverrideDefinition::new));
    final PropertiesPart properties;
    final WhenPart when;
    final ReplaceWithPart replacement;
    List<Function<FakeStyle, Boolean>> tests;
    @Nullable
    final List<ColourPredicateTest> colourTests;
    @Nullable
    final List<ColourPredicateTest> shadowColourTests;
    final SimpleEqualityTest<Boolean> boldTester;
    final SimpleEqualityTest<Boolean> italicTester;
    final SimpleEqualityTest<Boolean> underlinedTester;
    final SimpleEqualityTest<Boolean> strikethroughTester;
    final SimpleEqualityTest<Boolean> obfuscatedTester;
    @Nullable
    final List<FontPredicateTest> fontTests;
    final List<SimpleEqualityTest<DecorationType>> decorationTypeTests;
    @Nullable
    final List<CharacterPredicateTest> characterTests;

    public ColourOverrideDefinition(PropertiesPart propertiesPart, WhenPart whenPart, ReplaceWithPart replaceWithPart) {
        this.properties = propertiesPart;
        this.when = whenPart;
        this.replacement = replaceWithPart;
        this.colourTests = whenPart.colour;
        this.shadowColourTests = whenPart.shadowColour;
        this.boldTester = new SimpleEqualityTest<Boolean>(whenPart.bold);
        this.italicTester = new SimpleEqualityTest<Boolean>(whenPart.italic);
        this.underlinedTester = new SimpleEqualityTest<Boolean>(whenPart.underlined);
        this.strikethroughTester = new SimpleEqualityTest<Boolean>(whenPart.strikethrough);
        this.obfuscatedTester = new SimpleEqualityTest<Boolean>(whenPart.obfuscated);
        this.fontTests = whenPart.font;
        this.decorationTypeTests = whenPart.decorationType == null ? List.of() : whenPart.decorationType.stream().map(SimpleEqualityTest::new).toList();
        this.characterTests = whenPart.character;
        this.tests = List.of(style -> {
            if (this.colourTests == null || this.colourTests.isEmpty()) {
                return true;
            }
            return this.colourTests.stream().anyMatch(test -> test.matches(style.colour()));
        }, style -> {
            if (this.shadowColourTests == null || this.shadowColourTests.isEmpty()) {
                return true;
            }
            return this.shadowColourTests.stream().anyMatch(test -> test.matches(style.shadowColour() == null ? null : new SpecialTextColour(style.shadowColour())));
        }, style -> this.boldTester.matches(style.bold()), style -> this.italicTester.matches(style.italic()), style -> this.underlinedTester.matches(style.underlined()), style -> this.strikethroughTester.matches(style.strikethrough()), style -> this.obfuscatedTester.matches(style.obfuscated()), style -> {
            if (this.fontTests == null || this.fontTests.isEmpty()) {
                return true;
            }
            return this.fontTests.stream().anyMatch(test -> test.matches(style.font()));
        }, style -> {
            if (this.decorationTypeTests.isEmpty()) {
                return true;
            }
            return this.decorationTypeTests.stream().anyMatch(test -> test.matches(style.decorationType()));
        }, style -> {
            if (this.characterTests == null || this.characterTests.isEmpty()) {
                return true;
            }
            return this.characterTests.stream().anyMatch(test -> test.matches(style.codepoint()));
        });
    }

    public boolean styleMatches(FakeStyle style) {
        Profiling.push("check_style_matches");
        boolean result = this.tests.stream().allMatch(test -> (Boolean)test.apply(style));
        Profiling.pop();
        return result;
    }

    public FakeStyle applyToStyle(FakeStyle style) {
        Profiling.push("apply_to_style");
        FakeStyle newStyle = new FakeStyle(this.replacement.colour == null ? style.colour() : new SpecialTextColour(this.replacement.colour), this.replacement.shadowColour == null ? style.shadowColour() : this.replacement.shadowColour, style.bold(), style.italic(), style.underlined(), style.strikethrough(), style.obfuscated(), style.font(), style.decorationType(), style.codepoint(), this.properties);
        Profiling.pop();
        return newStyle;
    }

    public static void printExample() {
        DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new ColourOverrideDefinition(PropertiesPart.DEFAULT, new WhenPart(List.of(new ColourPredicateTest(new BasicColourPredicate(new SpecialTextColour("red")))), null, null, null, null, null, null, null, null, null), new ReplaceWithPart(0xFFFFFF, 0x777777)));
        if (result.error().isPresent()) {
            throw new RuntimeException(((DataResult.Error)result.error().get()).message());
        }
        Logging.info("Example file: {}", ((JsonElement)result.getOrThrow()).toString());
    }

    public record PropertiesPart(boolean autoGenerateShadow, float autoShadowMultiplier, boolean forceEnableShadow, boolean forceDisableShadow) {
        public static final boolean AUTO_GENERATE_SHADOW_DEFAULT = false;
        public static final float AUTO_SHADOW_MULTIPLIER_DEFAULT = 0.25f;
        public static final boolean FORCE_ENABLE_SHADOW_DEFAULT = false;
        public static final boolean FORCE_DISABLE_SHADOW_DEFAULT = false;
        public static final PropertiesPart DEFAULT = new PropertiesPart(false, 0.25f, false, false);
        private static final Codec<PropertiesPart> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("auto_generate_shadow", (Object)false).forGetter(part -> part.autoGenerateShadow), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("auto_shadow_multiplier", (Object)Float.valueOf(0.25f)).forGetter(part -> Float.valueOf(part.autoShadowMultiplier)), (App)Codec.BOOL.optionalFieldOf("force_enable_shadow", (Object)false).forGetter(part -> part.forceEnableShadow), (App)Codec.BOOL.optionalFieldOf("force_disable_shadow", (Object)false).forGetter(part -> part.forceDisableShadow)).apply((Applicative)instance, PropertiesPart::new));
    }

    public record WhenPart(@Nullable List<ColourPredicateTest> colour, @Nullable List<ColourPredicateTest> shadowColour, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable List<FontPredicateTest> font, @Nullable List<DecorationType> decorationType, @Nullable List<CharacterPredicateTest> character) {
        private static final Codec<WhenPart> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)COLOUR_PREDICATE_LIST_CODEC.optionalFieldOf("color").forGetter(part -> Optional.ofNullable(ColourPredicateTest.testsToPredicates(part.colour))), (App)COLOUR_PREDICATE_LIST_CODEC.optionalFieldOf("shadow_color").forGetter(part -> Optional.ofNullable(ColourPredicateTest.testsToPredicates(part.shadowColour))), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(part -> Optional.ofNullable(part.bold)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(part -> Optional.ofNullable(part.italic)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(part -> Optional.ofNullable(part.underlined)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(part -> Optional.ofNullable(part.strikethrough)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(part -> Optional.ofNullable(part.obfuscated)), (App)FONT_PREDICATE_LIST_CODEC.optionalFieldOf("font").forGetter(part -> Optional.ofNullable(FontPredicateTest.testsToPredicates(part.font))), (App)DECORATION_TYPE_LIST_CODEC.optionalFieldOf("decoration_type").forGetter(part -> Optional.ofNullable(part.decorationType)), (App)CHARACTER_PREDICATE_LIST_CODEC.optionalFieldOf("character").forGetter(part -> Optional.ofNullable(CharacterPredicateTest.testsToPredicates(part.character)))).apply((Applicative)instance, (colour, shadowColour, bold, italic, underlined, strikethrough, obfuscated, font, decorationType, characterPredicates) -> new WhenPart(ColourPredicateTest.predicatesToTests(colour.orElse(null)), ColourPredicateTest.predicatesToTests(shadowColour.orElse(null)), bold.orElse(null), italic.orElse(null), underlined.orElse(null), strikethrough.orElse(null), obfuscated.orElse(null), FontPredicateTest.predicatesToTests(font.orElse(null)), decorationType.orElse(null), CharacterPredicateTest.predicatesToTests(characterPredicates.orElse(null)))));
    }

    public record ReplaceWithPart(@Nullable Integer colour, @Nullable Integer shadowColour) {
        public static final Codec<ReplaceWithPart> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ColourCodecs.HEX_OR_RGB_LIST_CODEC.optionalFieldOf("color").forGetter(part -> Optional.ofNullable(part.colour)), (App)ColourCodecs.HEX_OR_RGB_LIST_CODEC.optionalFieldOf("shadow_color").forGetter(part -> Optional.ofNullable(part.shadowColour))).apply((Applicative)instance, (colour, shadowColour) -> new ReplaceWithPart(colour.orElse(null), shadowColour.orElse(null))));
    }
}

