/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.property_tests.colour.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_text_customiser.common.fake_style.SpecialTextColour;
import games.enchanted.eg_text_customiser.common.pack.property_tests.colour.predicates.ColourPredicate;
import games.enchanted.eg_text_customiser.common.serialization.ColourCodecs;

public class BasicColourPredicate
implements ColourPredicate {
    public static final boolean MATCH_NAMED_DEFAULT_DEFAULT = true;
    public static final Codec<? extends ColourPredicate> CODEC = ColourCodecs.HEX_OR_NAMED_CODEC.comapFlatMap(input -> DataResult.success((Object)new BasicColourPredicate(SpecialTextColour.fromEither((Either<Integer, String>)input))), input -> input.comparisonColour.getColourValueOrName());
    public static final MapCodec<BasicColourPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ColourCodecs.HEX_OR_NAMED_CODEC.fieldOf("value").forGetter(predicate -> predicate.comparisonColour.getColourValueOrName()), (App)Codec.BOOL.optionalFieldOf("match_named_colors", (Object)true).forGetter(predicate -> predicate.matchNamed)).apply((Applicative)instance, (colourValueOrName, strictMatchNamed) -> new BasicColourPredicate(SpecialTextColour.fromEither((Either<Integer, String>)colourValueOrName), (boolean)strictMatchNamed)));
    private final boolean matchNamed;
    private final SpecialTextColour comparisonColour;

    public BasicColourPredicate(SpecialTextColour comparisonColour) {
        this(comparisonColour, true);
    }

    public BasicColourPredicate(SpecialTextColour comparisonColour, boolean matchNamed) {
        this.matchNamed = matchNamed;
        this.comparisonColour = comparisonColour;
    }

    @Override
    public boolean colourMatches(SpecialTextColour colour) {
        if (colour == null) {
            return false;
        }
        return this.comparisonColour.compareTo(colour, this.matchNamed);
    }

    @Override
    public MapCodec<? extends ColourPredicate> codec() {
        return MAP_CODEC;
    }
}

