/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.property_tests.colour.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_text_customiser.common.fake_style.SpecialTextColour;
import games.enchanted.eg_text_customiser.common.pack.property_tests.colour.predicates.ColourPredicate;
import games.enchanted.eg_text_customiser.common.serialization.ColourCodecs;
import games.enchanted.eg_text_customiser.common.util.ColourUtil;

public class RangeColourPredicate
implements ColourPredicate {
    public static final MapCodec<RangeColourPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ColourCodecs.HEX_OR_RGB_LIST_CODEC.fieldOf("min").forGetter(predicate -> ColourUtil.RGB_to_RGBint(predicate.minComparison[0], predicate.minComparison[1], predicate.minComparison[2])), (App)ColourCodecs.HEX_OR_RGB_LIST_CODEC.fieldOf("max").forGetter(predicate -> ColourUtil.RGB_to_RGBint(predicate.maxComparison[0], predicate.maxComparison[1], predicate.maxComparison[2])), (App)Codec.BOOL.optionalFieldOf("match_named_colors", (Object)true).forGetter(predicate -> predicate.matchNamedColours)).apply((Applicative)instance, RangeColourPredicate::new));
    private final int[] minComparison;
    private final int[] maxComparison;
    private final boolean matchNamedColours;

    public RangeColourPredicate(Integer minComparison, Integer maxComparison, Boolean matchNamed) {
        this.minComparison = ColourUtil.RGBint_to_RGB(minComparison);
        this.maxComparison = ColourUtil.RGBint_to_RGB(maxComparison);
        this.matchNamedColours = matchNamed;
    }

    @Override
    public boolean colourMatches(SpecialTextColour colour) {
        if (colour == null) {
            return false;
        }
        if (!this.matchNamedColours && colour.isNamedColour()) {
            return false;
        }
        int[] testParts = ColourUtil.RGBint_to_RGB(colour.safeGetAsRGB());
        for (int i = 0; i < 3; ++i) {
            boolean inRange;
            boolean bl = inRange = testParts[i] >= this.minComparison[i] && testParts[i] <= this.maxComparison[i];
            if (inRange) continue;
            return false;
        }
        return true;
    }

    @Override
    public MapCodec<? extends ColourPredicate> codec() {
        return MAP_CODEC;
    }
}

