/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates.FontPredicate;
import java.util.Optional;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BasicAtlasFontPredicate
implements FontPredicate {
    public static final MapCodec<BasicAtlasFontPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("atlas").forGetter(predicate -> Optional.ofNullable(predicate.atlas)), (App)ResourceLocation.CODEC.optionalFieldOf("sprite").forGetter(predicate -> Optional.ofNullable(predicate.sprite))).apply((Applicative)instance, (atlasLocation, spriteLocation) -> new BasicAtlasFontPredicate(atlasLocation.orElse(null), spriteLocation.orElse(null))));
    @Nullable
    private final ResourceLocation atlas;
    @Nullable
    private final ResourceLocation sprite;

    public BasicAtlasFontPredicate(@Nullable ResourceLocation atlas, @Nullable ResourceLocation sprite) {
        this.atlas = atlas;
        this.sprite = sprite;
    }

    @Override
    public boolean fontMatches(FontDescription font) {
        if (!(font instanceof FontDescription.AtlasSprite)) {
            return false;
        }
        FontDescription.AtlasSprite spriteFont = (FontDescription.AtlasSprite)font;
        return !(this.atlas != null && !this.atlas.equals((Object)spriteFont.atlasId()) || this.sprite != null && !this.sprite.equals((Object)spriteFont.spriteId()));
    }

    @Override
    public MapCodec<? extends FontPredicate> codec() {
        return MAP_CODEC;
    }
}

