/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates.FontPredicate;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.component.ResolvableProfile;
import org.jetbrains.annotations.Nullable;

public class PlayerFontPredicate
implements FontPredicate {
    public static final MapCodec<PlayerFontPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.PATTERN.optionalFieldOf("name").forGetter(predicate -> Optional.ofNullable(predicate.name)), (App)Codec.BOOL.optionalFieldOf("hat").forGetter(predicate -> Optional.ofNullable(predicate.hat))).apply((Applicative)instance, (pattern, hat) -> new PlayerFontPredicate(pattern.orElse(null), hat.orElse(null))));
    @Nullable
    private final Pattern name;
    @Nullable
    private final Boolean hat;

    public PlayerFontPredicate(@Nullable Pattern name, @Nullable Boolean hat) {
        this.name = name;
        this.hat = hat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean fontMatches(FontDescription font) {
        boolean bl;
        ResolvableProfile profile;
        if (!(font instanceof FontDescription.PlayerSprite)) return false;
        FontDescription.PlayerSprite playerSprite = (FontDescription.PlayerSprite)font;
        try {
            ResolvableProfile resolvableProfile;
            profile = resolvableProfile = playerSprite.profile();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        boolean fontHat = bl = playerSprite.hat();
        Optional profileName = profile.name();
        if (this.name != null) {
            if (!profileName.filter(name -> this.name.pattern().matches((String)name)).isPresent()) return false;
        }
        if (this.hat == null) return true;
        if (this.hat != fontHat) return false;
        return true;
    }

    @Override
    public MapCodec<? extends FontPredicate> codec() {
        return null;
    }
}

