/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates.FontPredicate;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ResourceLocationPattern;

public class RegexAtlasFontPredicate
implements FontPredicate {
    public static final MapCodec<RegexAtlasFontPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocationPattern.CODEC.fieldOf("atlas").forGetter(predicate -> predicate.atlas), (App)ResourceLocationPattern.CODEC.fieldOf("sprite").forGetter(predicate -> predicate.sprite)).apply((Applicative)instance, RegexAtlasFontPredicate::new));
    private final ResourceLocationPattern atlas;
    private final ResourceLocationPattern sprite;

    public RegexAtlasFontPredicate(ResourceLocationPattern atlas, ResourceLocationPattern sprite) {
        this.atlas = atlas;
        this.sprite = sprite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean fontMatches(FontDescription font) {
        ResourceLocation atlasId;
        ResourceLocation resourceLocation;
        if (!(font instanceof FontDescription.AtlasSprite)) return false;
        FontDescription.AtlasSprite atlasSprite = (FontDescription.AtlasSprite)font;
        try {
            atlasId = resourceLocation = atlasSprite.atlasId();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ResourceLocation spriteId = resourceLocation = atlasSprite.spriteId();
        if (!this.atlas.locationPredicate().test(atlasId)) return false;
        if (!this.sprite.locationPredicate().test(spriteId)) return false;
        return true;
    }

    @Override
    public MapCodec<? extends FontPredicate> codec() {
        return MAP_CODEC;
    }
}

