/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.reload_listener;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import games.enchanted.eg_text_customiser.common.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public abstract class JsonReloadListener<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, T>> {
    protected final Codec<T> resourceCodec;
    protected final ResourceLocation listenerName;
    protected final FileToIdConverter fileToIdConverter;

    protected JsonReloadListener(Codec<T> resourceCodec, FileToIdConverter fileToIdConverter, ResourceLocation listenerName) {
        this.resourceCodec = resourceCodec;
        this.listenerName = listenerName;
        this.fileToIdConverter = fileToIdConverter;
    }

    @NotNull
    protected Map<ResourceLocation, T> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = new HashMap();
        this.parseFromDirectory(resourceManager, this.fileToIdConverter, this.resourceCodec, map);
        return map;
    }

    protected abstract void showErrors(Map<ResourceLocation, Exception> var1);

    private void parseFromDirectory(ResourceManager resourceManager, FileToIdConverter fileToIdConverter, Codec<T> resourceCodec, Map<ResourceLocation, T> outputMap) {
        HashMap<ResourceLocation, Exception> erroredFiles = new HashMap<ResourceLocation, Exception>();
        for (Map.Entry resource : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            ResourceLocation rawFileLocation = (ResourceLocation)resource.getKey();
            ResourceLocation idLocation = fileToIdConverter.fileToId(rawFileLocation);
            try {
                BufferedReader resourceReader = ((Resource)resource.getValue()).openAsReader();
                try {
                    resourceCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resourceReader)).ifSuccess(parsedResource -> {
                        Object prevValue = outputMap.putIfAbsent(idLocation, parsedResource);
                        if (prevValue != null) {
                            throw new IllegalStateException("Duplicate resource found '" + rawFileLocation.toString() + "', ignoring.");
                        }
                    }).ifError(error -> {
                        Logging.error("Failed to parse file '{}', with error '{}'", rawFileLocation, error);
                        erroredFiles.put(rawFileLocation, new Exception("Failed to parse file '" + String.valueOf(rawFileLocation) + "', with error '" + error.message() + "'"));
                    });
                }
                finally {
                    if (resourceReader == null) continue;
                    ((Reader)resourceReader).close();
                }
            }
            catch (IOException error2) {
                Logging.error("Failed to read file '{}', with error '{}'", rawFileLocation, error2);
                erroredFiles.put(rawFileLocation, error2);
            }
            catch (JsonParseException error3) {
                Logging.error("Failed to parse file '{}', with error '{}'", new Object[]{rawFileLocation, error3});
                erroredFiles.put(rawFileLocation, (Exception)((Object)error3));
            }
        }
        this.showErrors(erroredFiles);
    }

    @NotNull
    public String getName() {
        return this.listenerName.toString();
    }
}

