/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.serialization;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.resources.ResourceLocation;

public class ModCodecs {
    public static Codec<FontDescription> RESOURCE_FONT_DESCRIPTION = ResourceLocation.CODEC.flatComapMap(FontDescription.Resource::new, fontDescription -> {
        ResourceLocation id;
        if (!(fontDescription instanceof FontDescription.Resource)) return DataResult.error(() -> "Invalid font description type: " + String.valueOf(fontDescription) + ". Expected a Resource type");
        FontDescription.Resource $b$0 = (FontDescription.Resource)fontDescription;
        try {
            ResourceLocation patt1$temp;
            id = patt1$temp = $b$0.id();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)id);
    });

    public static <T> Codec<List<T>> singleOrListCodec(Codec<T> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(list -> list, List::of), list -> list.size() == 1 ? Either.right(list.getFirst()) : Either.left((Object)list));
    }

    public static <E, I> Codec<E> elmToIdCodec(Codec<I> codec, Function<I, E> IdToElm, Function<E, I> ElmToId) {
        return codec.flatXmap(input -> {
            Object elm = IdToElm.apply(input);
            return elm != null ? DataResult.success(elm) : DataResult.error(() -> "Unknown element id: " + String.valueOf(input));
        }, input -> {
            Object id = ElmToId.apply(input);
            if (id == null) {
                return DataResult.error(() -> "Element with unknown id: " + String.valueOf(input));
            }
            return DataResult.success(id);
        });
    }

    public static class IdToElmMapper<I, E> {
        private final BiMap<I, E> map = HashBiMap.create();

        public Codec<E> codec(Codec<I> codec) {
            BiMap inverseMap = this.map.inverse();
            return ModCodecs.elmToIdCodec(codec, arg_0 -> this.map.get(arg_0), arg_0 -> inverseMap.get(arg_0));
        }

        public IdToElmMapper<I, E> put(I id, E value) {
            if (value == null) {
                throw new IllegalArgumentException("Value for id cannot be null, (id: '" + String.valueOf(id) + "')");
            }
            this.map.put(id, value);
            return this;
        }
    }
}

