/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.util;

import java.util.Locale;

public class ColourUtil {
    public static int clampInt(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static int ARGB_to_ARGBint(int a, int r, int g, int b) {
        int alpha = ColourUtil.clampInt(a, 0, 255);
        int red = ColourUtil.clampInt(r, 0, 255);
        int green = ColourUtil.clampInt(g, 0, 255);
        int blue = ColourUtil.clampInt(b, 0, 255);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int[] ARGBint_to_ARGB(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int removeAlpha(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return r << 16 | g << 8 | b;
    }

    public static int extractAlpha(int argb) {
        int[] argbArray = ColourUtil.ARGBint_to_ARGB(argb);
        return ColourUtil.removeAlpha(argbArray[0]);
    }

    public static int applyAlpha(int rgb, int alpha) {
        int[] rgbArray = ColourUtil.RGBint_to_RGB(rgb);
        return ColourUtil.ARGB_to_ARGBint(alpha, rgbArray[0], rgbArray[1], rgbArray[2]);
    }

    public static int RGB_to_RGBint(int r, int g, int b) {
        int red = ColourUtil.clampInt(r, 0, 255);
        int green = ColourUtil.clampInt(g, 0, 255);
        int blue = ColourUtil.clampInt(b, 0, 255);
        return red << 16 | green << 8 | blue;
    }

    public static int[] RGBint_to_RGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new int[]{r, g, b};
    }

    public static int darkenRGB(int rgb, float scale) {
        int[] rgbParts = ColourUtil.RGBint_to_RGB(rgb);
        return ColourUtil.RGB_to_RGBint((int)((float)rgbParts[0] * scale), (int)((float)rgbParts[1] * scale), (int)((float)rgbParts[2] * scale));
    }

    public static String formatIntAsHexString(int colour) {
        return String.format(Locale.ROOT, "#%06X", colour);
    }

    public static int calcMainColour(boolean isDropShadow, float a, float r, float g, float b) {
        float dimFac = !isDropShadow ? 1.0f : 4.0f;
        return ColourUtil.ARGB_to_ARGBint((int)(a * 255.0f), (int)(r * dimFac * 255.0f), (int)(g * dimFac * 255.0f), (int)(b * dimFac * 255.0f));
    }

    public static int calcShadowColour(boolean isDropShadow, float a, float r, float g, float b) {
        float dimFac = !isDropShadow ? 0.25f : 1.0f;
        return ColourUtil.ARGB_to_ARGBint((int)(a * 255.0f), (int)(r * dimFac * 255.0f), (int)(g * dimFac * 255.0f), (int)(b * dimFac * 255.0f));
    }
}

