package games.enchanted.eg_text_customiser.common.mixin;

import games.enchanted.eg_text_customiser.common.duck.StyleAdditions;
import games.enchanted.eg_text_customiser.common.fake_style.SignTextData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10529;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_8242;

@Mixin(class_8242.class)
public abstract class SignTextMixin {
    @Shadow public abstract class_1767 getColor();
    @Shadow public abstract boolean hasGlowingText();

    @ModifyVariable(
        at = @At("TAIL"),
        method = "<init>([Lnet/minecraft/network/chat/Component;[Lnet/minecraft/network/chat/Component;Lnet/minecraft/world/item/DyeColor;Z)V",
        ordinal = 0,
        argsOnly = true
    )
    private class_2561[] eg_text_customiser$addSignTextDataToComponent(class_2561[] originalComponents) {
        if(originalComponents.length == 0) return originalComponents;
        List<class_2561> modifiedComponents = new ArrayList<>();
        for (class_2561 component : originalComponents) {
            if (!(component instanceof class_5250 mutableComponent)) {
                modifiedComponents.add(component);
                continue;
            }

            SignTextData signTextData;

            int darkColour =
                //? if minecraft: <= 1.21.4 {
                /*SignRenderer.getDarkColor((SignText) (Object) this);
                *///?} else {
                class_10529.method_65822((class_8242) (Object) this);
                //?}

            if(this.hasGlowingText()) {
                signTextData = new SignTextData(this.getColor(), this.hasGlowingText(), this.getColor().method_16357(), darkColour);
            } else {
                signTextData = new SignTextData(this.getColor(), this.hasGlowingText(), darkColour, null);
            }

            class_2583 style = mutableComponent.method_10866();
            style = ((StyleAdditions) (Object) style).eg_text_customiser$withSignTextData(signTextData);
            mutableComponent.method_10862(style);
            modifiedComponents.add(mutableComponent);
        }
        return modifiedComponents.toArray(new class_2561[0]);
    }
}
