package games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_11719;
import net.minecraft.class_2960;

public class BasicAtlasFontPredicate implements FontPredicate {
    public static final MapCodec<BasicAtlasFontPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            class_2960.field_25139.optionalFieldOf("atlas").forGetter(predicate -> Optional.ofNullable(predicate.atlas)),
            class_2960.field_25139.optionalFieldOf("sprite").forGetter(predicate -> Optional.ofNullable(predicate.sprite))
        ).apply(
            instance,
            (atlasLocation, spriteLocation) -> new BasicAtlasFontPredicate(
                atlasLocation.orElse(null),
                spriteLocation.orElse(null)
            )
        )
    );

    private final @Nullable class_2960 atlas;
    private final @Nullable class_2960 sprite;

    public BasicAtlasFontPredicate(@Nullable class_2960 atlas, @Nullable class_2960 sprite) {
        this.atlas = atlas;
        this.sprite = sprite;
    }

    @Override
    public boolean fontMatches(class_11719 font) {
        if(!(font instanceof class_11719.class_11720 spriteFont)) {
            return false;
        }
        return (this.atlas == null || this.atlas.equals(spriteFont.comp_4588())) && (this.sprite == null || this.sprite.equals(spriteFont.comp_4589()));
    }

    @Override
    public MapCodec<? extends FontPredicate> codec() {
        return MAP_CODEC;
    }
}
