package games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_11719;
import net.minecraft.class_5699;

public class PlayerFontPredicate implements FontPredicate {
    public static final MapCodec<PlayerFontPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            class_5699.field_37408.optionalFieldOf("name").forGetter(predicate -> Optional.ofNullable(predicate.name)),
            Codec.BOOL.optionalFieldOf("hat").forGetter(predicate -> Optional.ofNullable(predicate.hat))
        ).apply(
            instance,
            (pattern, hat) -> new PlayerFontPredicate(
                pattern.orElse(null),
                hat.orElse(null)
            )
        )
    );

    private final @Nullable Pattern name;
    private final @Nullable Boolean hat;

    public PlayerFontPredicate(@Nullable Pattern name, @Nullable Boolean hat) {
        this.name = name;
        this.hat = hat;
    }

    @Override
    public boolean fontMatches(class_11719 font) {
        if(!(font instanceof class_11719.class_11881(
            ResolvableProfile profile, boolean fontHat
        ))) {
            return false;
        }
        Optional<String> profileName = profile.method_73317();
        return
            (this.name == null || (profileName.filter(name -> this.name.pattern().matches(name)).isPresent())) &&
            (this.hat == null || this.hat == fontHat);
    }

    @Override
    public MapCodec<? extends FontPredicate> codec() {
        return null;
    }
}
