package games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_11719;
import net.minecraft.class_7085;

public class RegexAtlasFontPredicate implements FontPredicate {
    public static final MapCodec<RegexAtlasFontPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            class_7085.field_37293.fieldOf("atlas").forGetter(predicate -> predicate.atlas),
            class_7085.field_37293.fieldOf("sprite").forGetter(predicate -> predicate.sprite)
        ).apply(
            instance,
            RegexAtlasFontPredicate::new
        )
    );

    private final class_7085 atlas;
    private final class_7085 sprite;

    public RegexAtlasFontPredicate(class_7085 atlas, class_7085 sprite) {
        this.atlas = atlas;
        this.sprite = sprite;
    }

    @Override
    public boolean fontMatches(class_11719 font) {
        if(!(font instanceof class_11719.class_11720(ResourceLocation atlasId, ResourceLocation spriteId))) {
            return false;
        }
        return this.atlas.method_47548().test(atlasId) && this.sprite.method_47548().test(spriteId);
    }

    @Override
    public MapCodec<? extends FontPredicate> codec() {
        return MAP_CODEC;
    }
}
