package games.enchanted.eg_text_customiser.common.pack.property_tests.font.predicates;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_11719;
import net.minecraft.class_7085;

public class RegexFontPredicate implements FontPredicate {
    public static final MapCodec<RegexFontPredicate> MAP_CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            class_7085.field_37293.fieldOf("regex").forGetter(predicate -> predicate.pattern)
        ).apply(
            instance,
            RegexFontPredicate::new
        )
    );

    private final class_7085 pattern;

    public RegexFontPredicate(class_7085 pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean fontMatches(class_11719 font) {
        if(!(font instanceof class_11719.class_11721(ResourceLocation id))) {
            return false;
        }
        return pattern.method_47548().test(id);
    }

    @Override
    public MapCodec<? extends FontPredicate> codec() {
        return MAP_CODEC;
    }
}
