package games.enchanted.eg_text_customiser.common.pack.reload_listener;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import games.enchanted.eg_text_customiser.common.Logging;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

public abstract class JsonReloadListener<T> extends class_4080<Map<class_2960, T>> {
    protected final Codec<T> resourceCodec;
    protected final class_2960 listenerName;
    protected final class_7654 fileToIdConverter;

    protected JsonReloadListener(Codec<T> resourceCodec, class_7654 fileToIdConverter, class_2960 listenerName) {
        this.resourceCodec = resourceCodec;
        this.listenerName = listenerName;
        this.fileToIdConverter = fileToIdConverter;
    }

    @Override
    protected @NotNull Map<class_2960, T> method_18789(class_3300 resourceManager, class_3695 profiler) {
        Map<class_2960, T> map = new HashMap<>();
        parseFromDirectory(resourceManager, this.fileToIdConverter, this.resourceCodec, map);
        return map;
    }

    protected abstract void showErrors(Map<class_2960, Exception> erroredFiles);

    private void parseFromDirectory(class_3300 resourceManager, class_7654 fileToIdConverter, Codec<T> resourceCodec, Map<class_2960, T> outputMap) {
        Map<class_2960, Exception> erroredFiles = new HashMap<>();
        for(Map.Entry<class_2960, class_3298> resource : fileToIdConverter.method_45113(resourceManager).entrySet()) {
            class_2960 rawFileLocation = resource.getKey();
            class_2960 idLocation = fileToIdConverter.method_45115(rawFileLocation);

            try(Reader resourceReader = resource.getValue().method_43039()) {
                resourceCodec.parse(JsonOps.INSTANCE, JsonParser.parseReader(resourceReader)).ifSuccess(parsedResource -> {
                    T prevValue = outputMap.putIfAbsent(idLocation, parsedResource);
                    if(prevValue != null) {
                        throw new IllegalStateException("Duplicate resource found '" + rawFileLocation.toString() + "', ignoring.");
                    }
                }).ifError(error -> {
                    Logging.error("Failed to parse file '{}', with error '{}'", rawFileLocation, error);
                    erroredFiles.put(rawFileLocation, new Exception("Failed to parse file '" + rawFileLocation + "', with error '" + error.message() + "'"));
                });
            } catch (IOException error) {
                Logging.error("Failed to read file '{}', with error '{}'", rawFileLocation, error);
                erroredFiles.put(rawFileLocation, error);
            } catch (JsonParseException error) {
                Logging.error("Failed to parse file '{}', with error '{}'", rawFileLocation, error);
                erroredFiles.put(rawFileLocation, error);
            }
        }
        showErrors(erroredFiles);
    }

    @Override
    public @NotNull String method_22322() {
        return listenerName.toString();
    }
}
