/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.fake_style;

import games.enchanted.eg_text_customiser.common.fake_style.DecorationType;
import games.enchanted.eg_text_customiser.common.fake_style.SpecialTextColour;
import games.enchanted.eg_text_customiser.common.pack.colour_override.ColourOverrideDefinition;
import games.enchanted.eg_text_customiser.common.util.ColourUtil;
import java.util.Objects;
import net.minecraft.class_11719;
import net.minecraft.class_2960;
import net.minecraft.class_9296;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FakeStyle(@Nullable SpecialTextColour colour, @Nullable Integer shadowColour, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable class_11719 font, @Nullable DecorationType decorationType, @Nullable Integer codepoint, ColourOverrideDefinition.PropertiesPart properties) {
    public FakeStyle(@Nullable SpecialTextColour colour, @Nullable Integer shadowColour, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable class_11719 font, @Nullable DecorationType decorationType, @Nullable Integer codepoint) {
        this(colour, shadowColour, bold, italic, underlined, strikethrough, obfuscated, font, decorationType, codepoint, ColourOverrideDefinition.PropertiesPart.DEFAULT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        SpecialTextColour colour1;
        Object object;
        if (!(o instanceof FakeStyle)) return false;
        FakeStyle fakeStyle = (FakeStyle)o;
        try {
            object = fakeStyle.colour();
            colour1 = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object shadowColour1 = object = fakeStyle.shadowColour();
        Object bold1 = object = fakeStyle.bold();
        Object italic1 = object = fakeStyle.italic();
        Object underlined1 = object = fakeStyle.underlined();
        Object strikethrough1 = object = fakeStyle.strikethrough();
        Object obfuscated1 = object = fakeStyle.obfuscated();
        Object font1 = object = fakeStyle.font();
        Object type = object = fakeStyle.decorationType();
        Object codepoint1 = object = fakeStyle.codepoint();
        Object properties1 = object = fakeStyle.properties();
        if (!Objects.equals(this.bold, bold1)) return false;
        if (!Objects.equals(this.italic, italic1)) return false;
        if (!Objects.equals(this.underlined, underlined1)) return false;
        if (!Objects.equals(this.obfuscated, obfuscated1)) return false;
        if (!Objects.equals(this.shadowColour, shadowColour1)) return false;
        if (!Objects.equals(this.strikethrough, strikethrough1)) return false;
        if (!Objects.equals(this.font, font1)) return false;
        if (!Objects.equals(this.colour, colour1)) return false;
        if (!Objects.equals((Object)this.decorationType, type)) return false;
        if (!Objects.equals(this.codepoint, codepoint1)) return false;
        if (!Objects.equals(this.properties, properties1)) return false;
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return "FakeStyle{colour=" + String.valueOf(this.colour) + ", shadowColour=" + this.shadowColour + ", bold=" + this.bold + ", italic=" + this.italic + ", underlined=" + this.underlined + ", strikethrough=" + this.strikethrough + ", obfuscated=" + this.obfuscated + ", font=" + String.valueOf(this.font) + ", decorationType=" + String.valueOf((Object)this.decorationType) + ", codepoint=" + this.codepoint + ", properties=" + String.valueOf(this.properties) + "}";
    }

    @NotNull
    public String formattedString() {
        return "[" + (String)(this.colour == null ? "" : "color=\"" + this.colour.formattedString() + "\"") + (String)(this.shadowColour == null ? "" : ", shadow_color=\"" + ColourUtil.formatIntAsHexString(this.shadowColour) + "\"") + (String)(this.bold == null ? "" : ", bold=" + this.bold) + (String)(this.italic == null ? "" : ", italic=" + this.italic) + (String)(this.underlined == null ? "" : ", underlined=" + this.underlined) + (String)(this.strikethrough == null ? "" : ", strikethrough=" + this.strikethrough) + (String)(this.obfuscated == null ? "" : ", obfuscated=" + this.obfuscated) + (String)(this.font == null ? "" : ", font=" + FakeStyle.formatFontDescription(this.font)) + (String)(this.decorationType == null ? "" : ", decoration_type=\"" + String.valueOf((Object)this.decorationType) + "\"") + (String)(this.codepoint == null ? "" : ", character=[codepoint=" + this.codepoint + ", char=" + (char)this.codepoint.intValue() + "]") + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String formatFontDescription(class_11719 font) {
        boolean bl;
        class_9296 profile;
        if (font instanceof class_11719.class_11721) {
            class_2960 class_29602;
            class_11719.class_11721 class_117212 = (class_11719.class_11721)font;
            class_2960 id = class_29602 = class_117212.comp_4590();
            return "\"" + String.valueOf(id) + "\"";
        }
        if (font instanceof class_11719.class_11720) {
            class_2960 class_29603;
            class_11719.class_11720 class_117202 = (class_11719.class_11720)font;
            class_2960 atlasId = class_29603 = class_117202.comp_4588();
            class_2960 spriteId = class_29603 = class_117202.comp_4589();
            return "[type=atlas_sprite, atlas\"" + String.valueOf(atlasId) + "\", sprite\"" + String.valueOf(spriteId) + "\"]";
        }
        if (!(font instanceof class_11719.class_11881)) return "unknown";
        class_11719.class_11881 class_118812 = (class_11719.class_11881)font;
        try {
            class_9296 class_92962;
            profile = class_92962 = class_118812.comp_4761();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        boolean hat = bl = class_118812.comp_4762();
        return "[type=profile, name\"" + profile.method_73317().orElse("<none>") + "\", hat\"" + hat + "\"]";
    }
}

