/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack;

import games.enchanted.eg_text_customiser.common.Logging;
import games.enchanted.eg_text_customiser.common.config.ConfigValues;
import games.enchanted.eg_text_customiser.common.duck.StyleAdditions;
import games.enchanted.eg_text_customiser.common.fake_style.DecorationType;
import games.enchanted.eg_text_customiser.common.fake_style.FakeStyle;
import games.enchanted.eg_text_customiser.common.fake_style.SignTextData;
import games.enchanted.eg_text_customiser.common.fake_style.SpecialTextColour;
import games.enchanted.eg_text_customiser.common.pack.colour_override.ColourOverrideDefinition;
import games.enchanted.eg_text_customiser.common.util.ColourUtil;
import games.enchanted.eg_text_customiser.common.util.Profiling;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextOverrideManager {
    private static final Map<class_2960, ColourOverrideDefinition> COLOUR_OVERRIDE_DEFINITIONS = new HashMap<class_2960, ColourOverrideDefinition>();
    private static final Map<FakeStyle, FakeStyle> MATCHED_STYLES = new HashMap<FakeStyle, FakeStyle>();
    private static final HashSet<FakeStyle> UNMATCHED_STYLED = new HashSet();

    private static void logStyle(FakeStyle style, @Nullable class_2960 matchedTo) {
        if (!ConfigValues.TEXT_DEBUG_LOGS) {
            return;
        }
        String matchedPart = matchedTo != null ? "(and matched to '" + String.valueOf(matchedTo) + "')" : "(didn't match)";
        Logging.info("Seen {} style:\n{}", matchedPart, style.formattedString());
    }

    @Nullable
    private static ColourOverrideDefinition getDefinitionForStyle(@NotNull FakeStyle style) {
        Profiling.push("check_unmatched");
        if (UNMATCHED_STYLED.contains(style)) {
            Profiling.pop();
            return null;
        }
        Profiling.pop();
        Profiling.push("loop");
        for (Map.Entry<class_2960, ColourOverrideDefinition> entry : COLOUR_OVERRIDE_DEFINITIONS.entrySet()) {
            Profiling.push("try_find_match");
            if (entry.getValue().styleMatches(style)) {
                TextOverrideManager.logStyle(style, entry.getKey());
                MATCHED_STYLES.put(style, entry.getValue().applyToStyle(style));
                Profiling.pop();
                return entry.getValue();
            }
            Profiling.pop();
        }
        Profiling.pop();
        TextOverrideManager.logStyle(style, null);
        UNMATCHED_STYLED.add(style);
        return null;
    }

    public static synchronized FakeStyle applyFakeColourOverride(@NotNull FakeStyle originalStyle) {
        Profiling.push("check_matched");
        @Nullable FakeStyle matchedStyle = MATCHED_STYLES.get(originalStyle);
        if (matchedStyle != null) {
            Profiling.pop();
            return matchedStyle;
        }
        Profiling.pop();
        Profiling.push("get_definition");
        ColourOverrideDefinition overrideDefinition = TextOverrideManager.getDefinitionForStyle(originalStyle);
        Profiling.pop();
        Profiling.push("check_null_or_apply");
        if (overrideDefinition == null) {
            Profiling.pop();
            return originalStyle;
        }
        Profiling.pop();
        return overrideDefinition.applyToStyle(originalStyle);
    }

    public static void registerOverride(class_2960 location, ColourOverrideDefinition definition) {
        COLOUR_OVERRIDE_DEFINITIONS.put(location, definition);
    }

    public static void clearCaches() {
        COLOUR_OVERRIDE_DEFINITIONS.clear();
        MATCHED_STYLES.clear();
        UNMATCHED_STYLED.clear();
    }

    public static void replaceColour(int color, int shadowColor, class_2583 style, boolean hasShadow, DecorationType decorationType, @Nullable Integer codepoint, ColourApplier colourApplier, ShadowColourApplier shadowColourApplier) {
        int shadowAlpha;
        boolean isValidSignText;
        boolean currentlyOutlineColour;
        boolean currentlyRegularColour;
        if (ConfigValues.DISABLE_MOD || COLOUR_OVERRIDE_DEFINITIONS.isEmpty()) {
            return;
        }
        Profiling.push("replace_glyph_colour");
        int noAlphaColour = ColourUtil.removeAlpha(color);
        SignTextData signTextData = ((StyleAdditions)style).eg_text_customiser$getSignTextData();
        if (signTextData != null) {
            currentlyRegularColour = noAlphaColour == ColourUtil.removeAlpha(signTextData.darkColour());
            currentlyOutlineColour = signTextData.outlineColour() != null && noAlphaColour == ColourUtil.removeAlpha(signTextData.outlineColour());
        } else {
            currentlyRegularColour = false;
            currentlyOutlineColour = false;
        }
        boolean bl = isValidSignText = currentlyRegularColour || currentlyOutlineColour;
        SpecialTextColour comparisonTextColour = !isValidSignText && style.method_10973() != null ? SpecialTextColour.fromTextColor(style.method_10973()) : (isValidSignText ? SpecialTextColour.fromSignTextData(signTextData, currentlyOutlineColour) : new SpecialTextColour(noAlphaColour));
        int noAlphaShadowColour = ColourUtil.removeAlpha(shadowColor);
        FakeStyle fakeStyle = new FakeStyle(comparisonTextColour, shadowColor == 0 ? null : Integer.valueOf(noAlphaShadowColour), style.method_10984(), style.method_10966(), style.method_10965(), style.method_10986(), style.method_10987(), style.method_27708(), decorationType, codepoint);
        FakeStyle newStyle = TextOverrideManager.applyFakeColourOverride(fakeStyle);
        int colorAlpha = ColourUtil.extractAlpha(color);
        if (newStyle.colour() != null) {
            int newColour = newStyle.colour().safeGetAsRGB();
            colourApplier.applyColour(ColourUtil.applyAlpha(newColour, colorAlpha));
        }
        if (newStyle.properties().forceDisableShadow()) {
            shadowColourApplier.applyShadowColour(0);
        }
        if (!hasShadow && !newStyle.properties().forceEnableShadow()) {
            Profiling.pop();
            return;
        }
        int n = shadowAlpha = newStyle.properties().forceEnableShadow() ? colorAlpha : ColourUtil.extractAlpha(shadowColor);
        if (newStyle.properties().forceDisableShadow()) {
            shadowColourApplier.applyShadowColour(0);
        } else if (newStyle.colour() != null && newStyle.shadowColour() != null && newStyle.shadowColour() == noAlphaShadowColour && newStyle.properties().autoGenerateShadow()) {
            shadowColourApplier.applyShadowColour(ColourUtil.applyAlpha(ColourUtil.darkenRGB(newStyle.colour().safeGetAsRGB(), newStyle.properties().autoShadowMultiplier()), shadowAlpha));
        } else if (newStyle.shadowColour() != null) {
            shadowColourApplier.applyShadowColour(ColourUtil.applyAlpha(newStyle.shadowColour(), shadowAlpha));
        }
        Profiling.pop();
    }

    @FunctionalInterface
    public static interface ColourApplier {
        public void applyColour(Integer var1);
    }

    @FunctionalInterface
    public static interface ShadowColourApplier {
        public void applyShadowColour(Integer var1);
    }
}

