/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_text_customiser.common.pack.reload_listener;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import games.enchanted.eg_text_customiser.common.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;

public abstract class JsonReloadListener<T>
extends class_4080<Map<class_2960, T>> {
    protected final Codec<T> resourceCodec;
    protected final class_2960 listenerName;
    protected final class_7654 fileToIdConverter;

    protected JsonReloadListener(Codec<T> resourceCodec, class_7654 fileToIdConverter, class_2960 listenerName) {
        this.resourceCodec = resourceCodec;
        this.listenerName = listenerName;
        this.fileToIdConverter = fileToIdConverter;
    }

    @NotNull
    protected Map<class_2960, T> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap map = new HashMap();
        this.parseFromDirectory(resourceManager, this.fileToIdConverter, this.resourceCodec, map);
        return map;
    }

    protected abstract void showErrors(Map<class_2960, Exception> var1);

    private void parseFromDirectory(class_3300 resourceManager, class_7654 fileToIdConverter, Codec<T> resourceCodec, Map<class_2960, T> outputMap) {
        HashMap<class_2960, Exception> erroredFiles = new HashMap<class_2960, Exception>();
        for (Map.Entry resource : fileToIdConverter.method_45113(resourceManager).entrySet()) {
            class_2960 rawFileLocation = (class_2960)resource.getKey();
            class_2960 idLocation = fileToIdConverter.method_45115(rawFileLocation);
            try {
                BufferedReader resourceReader = ((class_3298)resource.getValue()).method_43039();
                try {
                    resourceCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resourceReader)).ifSuccess(parsedResource -> {
                        Object prevValue = outputMap.putIfAbsent(idLocation, parsedResource);
                        if (prevValue != null) {
                            throw new IllegalStateException("Duplicate resource found '" + rawFileLocation.toString() + "', ignoring.");
                        }
                    }).ifError(error -> {
                        Logging.error("Failed to parse file '{}', with error '{}'", rawFileLocation, error);
                        erroredFiles.put(rawFileLocation, new Exception("Failed to parse file '" + String.valueOf(rawFileLocation) + "', with error '" + error.message() + "'"));
                    });
                }
                finally {
                    if (resourceReader == null) continue;
                    ((Reader)resourceReader).close();
                }
            }
            catch (IOException error2) {
                Logging.error("Failed to read file '{}', with error '{}'", rawFileLocation, error2);
                erroredFiles.put(rawFileLocation, error2);
            }
            catch (JsonParseException error3) {
                Logging.error("Failed to parse file '{}', with error '{}'", new Object[]{rawFileLocation, error3});
                erroredFiles.put(rawFileLocation, (Exception)((Object)error3));
            }
        }
        this.showErrors(erroredFiles);
    }

    @NotNull
    public String method_22322() {
        return this.listenerName.toString();
    }
}

