/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo;

import builderb0y.vertigo.ChunkTrackingManager;
import builderb0y.vertigo.SectionTrackingManager;
import builderb0y.vertigo.WeakIdentityHashMap;
import builderb0y.vertigo.networking.LoadRangePacket;
import builderb0y.vertigo.networking.VertigoInstalledPacket;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class TrackingManager {
    public static final WeakIdentityHashMap<class_3222, TrackingManager> PLAYERS = new WeakIdentityHashMap();
    public static TrackingManager CLIENT;

    @Environment(value=EnvType.CLIENT)
    public static TrackingManager createClient() {
        if (ClientPlayNetworking.canSend((class_2960)VertigoInstalledPacket.PACKET_ID)) {
            return new SectionTrackingManager();
        }
        return new ChunkTrackingManager();
    }

    public static TrackingManager create(class_3222 player) {
        if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)LoadRangePacket.PACKET_ID)) {
            return new SectionTrackingManager(player);
        }
        return new ChunkTrackingManager(player);
    }

    public boolean otherSideHasVertigoInstalled() {
        return this instanceof SectionTrackingManager;
    }

    public static void tickAll(MinecraftServer server) {
        if (!PLAYERS.isEmpty()) {
            Iterator<Map.Entry<class_3222, TrackingManager>> iterator = PLAYERS.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_3222, TrackingManager> entry = iterator.next();
                class_3222 player = entry.getKey();
                TrackingManager manager = entry.getValue();
                if (player.method_14239()) {
                    manager.clear();
                    iterator.remove();
                    continue;
                }
                manager.update(player);
            }
        }
    }

    public abstract boolean isLoaded(int var1, int var2, int var3);

    @Nullable
    public abstract LoadedRange getLoadedRange(int var1, int var2);

    public abstract void update(class_3222 var1);

    public abstract void onChunkLoaded(class_3222 var1, int var2, int var3);

    public abstract void onChunkUnloaded(class_3222 var1, int var2, int var3);

    @Environment(value=EnvType.CLIENT)
    public abstract void onChunkLoadedClient(class_2818 var1);

    @Environment(value=EnvType.CLIENT)
    public abstract void onChunkUnloadedClient(class_2818 var1);

    public abstract void onLightingChanged(class_2338 var1);

    public abstract void clear();

    static {
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            TrackingManager manager = PLAYERS.get(oldPlayer);
            if (manager != null) {
                PLAYERS.put(newPlayer, manager);
            }
        });
    }

    @FunctionalInterface
    public static interface LoadedRange {
        public boolean isLoaded(int var1);
    }
}

