/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    public static final Hash.Strategy<Object> STRATEGY = new Hash.Strategy<Object>(){

        public int hashCode(Object object) {
            if (object instanceof WeakIdentityReference) {
                return object.hashCode();
            }
            return System.identityHashCode(object);
        }

        public boolean equals(Object a, Object b) {
            if (a != null && b != null) {
                WeakIdentityReference reference;
                if (a instanceof WeakIdentityReference) {
                    reference = (WeakIdentityReference)a;
                    a = reference.get();
                }
                if (b instanceof WeakIdentityReference) {
                    reference = (WeakIdentityReference)b;
                    b = reference.get();
                }
            }
            return a == b;
        }
    };
    public final Object2ObjectOpenCustomHashMap<Object, V> delegate;
    public final ReferenceQueue<K> queue = new ReferenceQueue();
    public KeySet keySet;
    public EntrySet entrySet;

    public WeakIdentityHashMap() {
        this.delegate = new Object2ObjectOpenCustomHashMap(STRATEGY);
    }

    public WeakIdentityHashMap(int capacity) {
        this.delegate = new Object2ObjectOpenCustomHashMap(capacity, STRATEGY);
    }

    public void purge() {
        Reference<K> reference;
        while ((reference = this.queue.poll()) != null) {
            this.delegate.remove(reference);
        }
    }

    @Override
    public int size() {
        this.purge();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.purge();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.purge();
        if (key == null) {
            return false;
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.purge();
        if (value == null) {
            return false;
        }
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.purge();
        if (key == null) {
            return null;
        }
        return (V)this.delegate.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.purge();
        return (V)this.delegate.put(new WeakIdentityReference<K>(this.queue, key), value);
    }

    @Override
    public V remove(Object key) {
        this.purge();
        if (key == null) {
            return null;
        }
        return (V)this.delegate.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.purge();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = Objects.requireNonNull(entry.getKey(), "map contains null key");
            V value = Objects.requireNonNull(entry.getValue(), "map contains null value");
            this.delegate.put(new WeakIdentityReference<K>(this.queue, key), value);
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.keySet == null ? (this.keySet = new KeySet()) : this.keySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet == null ? (this.entrySet = new EntrySet()) : this.entrySet;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        this.purge();
        return (V)this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.purge();
        this.delegate.forEach((reference, value) -> {
            Object key = ((WeakIdentityReference)reference).get();
            if (key != null) {
                action.accept((Object)key, (Object)value);
            }
        });
    }

    @Override
    public void replaceAll(final BiFunction<? super K, ? super V, ? extends V> function) {
        this.purge();
        class Wrapper
        implements BiFunction<Object, V, V> {
            public boolean containedNull;

            Wrapper() {
            }

            @Override
            public V apply(Object reference, V value) {
                Object key = ((WeakIdentityReference)reference).get();
                if (key != null) {
                    return function.apply(key, value);
                }
                this.containedNull = true;
                return null;
            }
        }
        Wrapper wrapper = new Wrapper();
        this.delegate.replaceAll((BiFunction)wrapper);
        if (wrapper.containedNull) {
            this.delegate.values().removeIf(Objects::isNull);
        }
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        this.purge();
        return (V)this.delegate.putIfAbsent(new WeakIdentityReference<K>(this.queue, key), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.purge();
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.purge();
        return this.delegate.replace(new WeakIdentityReference<K>(this.queue, key), oldValue, newValue);
    }

    @Override
    @Nullable
    public V replace(K key, V value) {
        this.purge();
        return (V)this.delegate.replace(new WeakIdentityReference<K>(this.queue, key), value);
    }

    @Override
    public V computeIfAbsent(K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
        this.purge();
        return (V)this.delegate.computeIfAbsent(new WeakIdentityReference<K>(this.queue, key), reference -> mappingFunction.apply((Object)key));
    }

    @Override
    public V computeIfPresent(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.purge();
        return (V)this.delegate.computeIfPresent(new WeakIdentityReference<K>(this.queue, key), (reference, value) -> remappingFunction.apply((Object)key, (Object)value));
    }

    @Override
    public V compute(K key, @NotNull BiFunction<? super K, ? super @Nullable V, ? extends V> remappingFunction) {
        this.purge();
        return (V)this.delegate.compute(new WeakIdentityReference<K>(this.queue, key), (reference, value) -> remappingFunction.apply((Object)key, (Object)value));
    }

    @Override
    public V merge(K key, @NotNull V value, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.purge();
        return (V)this.delegate.merge(new WeakIdentityReference<K>(this.queue, key), value, remappingFunction);
    }

    public static class WeakIdentityReference<K>
    extends WeakReference<K> {
        public final int hashCode;

        public WeakIdentityReference(ReferenceQueue<? super K> queue, K key) {
            super(key, queue);
            this.hashCode = System.identityHashCode(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof WeakIdentityReference)) return false;
            WeakIdentityReference that = (WeakIdentityReference)obj;
            if (this.get() != that.get()) return false;
            return true;
        }
    }

    public class KeySet
    implements Set<K> {
        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return WeakIdentityHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return WeakIdentityHashMap.this.containsKey(object);
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return new KeyIterator((Iterator<Object>)WeakIdentityHashMap.this.delegate.keySet().iterator());
        }

        @Override
        @NotNull
        public Object[] toArray() {
            ArrayList list = new ArrayList(this.size());
            for (Object object : this) {
                list.add(object);
            }
            return list.toArray();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] array) {
            ArrayList list = new ArrayList(this.size());
            for (Object object : this) {
                list.add(object);
            }
            return list.toArray(array);
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            return WeakIdentityHashMap.this.remove(object) != null;
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> collection) {
            WeakIdentityHashMap.this.purge();
            Object2ObjectOpenCustomHashMap delegate = WeakIdentityHashMap.this.delegate;
            for (Object object : collection) {
                if (delegate.containsKey(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> collection) {
            return WeakIdentityHashMap.this.delegate.keySet().removeIf(reference -> {
                Object key = ((WeakIdentityReference)reference).get();
                return key == null || !collection.contains(key);
            });
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> collection) {
            return WeakIdentityHashMap.this.delegate.keySet().removeIf(reference -> {
                Object key = ((WeakIdentityReference)reference).get();
                return key == null || collection.contains(key);
            });
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public <T> T[] toArray(@NotNull IntFunction<T[]> generator) {
            ArrayList list = new ArrayList(this.size());
            for (Object object : this) {
                list.add(object);
            }
            return list.toArray(generator.apply(list.size()));
        }

        @Override
        public boolean removeIf(@NotNull Predicate<? super K> filter) {
            return WeakIdentityHashMap.this.delegate.keySet().removeIf(reference -> {
                Object key = ((WeakIdentityReference)reference).get();
                return key == null || filter.test((Object)key);
            });
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            ObjectIterator iterator = WeakIdentityHashMap.this.delegate.keySet().iterator();
            while (iterator.hasNext()) {
                Object next = ((WeakIdentityReference)iterator.next()).get();
                if (next != null) {
                    action.accept(next);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public class EntrySet
    implements Set<Map.Entry<K, V>> {
        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return WeakIdentityHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                WeakIdentityHashMap.this.purge();
                return WeakIdentityHashMap.this.delegate.containsKey(entry.getKey()) && WeakIdentityHashMap.this.delegate.containsValue(entry.getValue());
            }
            return false;
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(WeakIdentityHashMap.this.delegate.entrySet().iterator());
        }

        @Override
        @NotNull
        public Object[] toArray() {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                list.add(entry);
            }
            return list.toArray();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] array) {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                list.add(entry);
            }
            return list.toArray(array);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            Map.Entry entry;
            return object instanceof Map.Entry && WeakIdentityHashMap.this.remove((entry = (Map.Entry)object).getKey(), entry.getValue());
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> collection) {
            WeakIdentityHashMap.this.purge();
            Object2ObjectOpenCustomHashMap delegate = WeakIdentityHashMap.this.delegate;
            for (Object object : collection) {
                Map.Entry entry;
                if (object instanceof Map.Entry && delegate.containsKey((entry = (Map.Entry)object).getKey()) && delegate.containsValue(entry.getValue())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> collection) {
            return WeakIdentityHashMap.this.delegate.entrySet().removeIf(entry -> {
                Object key = ((WeakIdentityReference)entry.getKey()).get();
                return key == null || !collection.contains(Map.entry(key, entry.getValue()));
            });
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> collection) {
            return WeakIdentityHashMap.this.delegate.entrySet().removeIf(entry -> {
                Object key = ((WeakIdentityReference)entry.getKey()).get();
                return key == null || collection.contains(Map.entry(key, entry.getValue()));
            });
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public <T> T[] toArray(@NotNull IntFunction<T[]> generator) {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry object : this) {
                list.add(object);
            }
            return list.toArray(generator.apply(list.size()));
        }

        @Override
        public boolean removeIf(@NotNull Predicate<? super Map.Entry<K, V>> filter) {
            return WeakIdentityHashMap.this.delegate.entrySet().removeIf(entry -> {
                Object key = ((WeakIdentityReference)entry.getKey()).get();
                return key == null || !filter.test(Map.entry(key, entry.getValue()));
            });
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            ObjectIterator iterator = WeakIdentityHashMap.this.delegate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object key = ((WeakIdentityReference)entry.getKey()).get();
                if (key != null) {
                    action.accept(Map.entry(key, entry.getValue()));
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public static class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        public final Iterator<Map.Entry<Object, V>> delegate;
        public Map.Entry<K, V> next;

        public EntryIterator(Iterator<Map.Entry<Object, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (!this.delegate.hasNext()) {
                    return false;
                }
                Map.Entry<Object, V> next = this.delegate.next();
                Object key = ((WeakIdentityReference)next.getKey()).get();
                if (key == null) continue;
                V value = next.getValue();
                this.next = Map.entry(key, value);
            }
            return true;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hasNext()) {
                Map.Entry<K, V> next = this.next;
                this.next = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    public static class KeyIterator<K>
    implements Iterator<K> {
        public final Iterator<Object> delegate;
        public K next;

        public KeyIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (!this.delegate.hasNext()) {
                    return false;
                }
                this.next = ((WeakIdentityReference)this.delegate.next()).get();
            }
            return true;
        }

        @Override
        public K next() {
            if (this.hasNext()) {
                K next = this.next;
                this.next = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

