/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo.networking;

import builderb0y.vertigo.VersionUtil;
import builderb0y.vertigo.Vertigo;
import builderb0y.vertigo.api.VertigoClientEvents;
import builderb0y.vertigo.networking.VertigoS2CPacket;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public record ChunkSectionLoadPacket(int sectionX, int sectionY, int sectionZ, Either<byte[], class_2826> sectionData, Optional<byte[]> skylightData, List<BlockEntityData> blockEntities) implements VertigoS2CPacket
{
    public static final class_2960 PACKET_ID = Vertigo.modID("section_load");
    public static final PacketType<ChunkSectionLoadPacket> TYPE = PacketType.create((class_2960)PACKET_ID, ChunkSectionLoadPacket::read);

    public static ChunkSectionLoadPacket read(class_2540 buffer) {
        Optional<Object> skylightData;
        int sectionX = buffer.readInt();
        int sectionY = buffer.readInt();
        int sectionZ = buffer.readInt();
        class_2826 section = VersionUtil.newEmptyChunkSection(class_310.method_1551().field_1687.method_30349());
        section.method_12258(buffer);
        if (buffer.readBoolean()) {
            skylightData = Optional.of(new byte[2048]);
            buffer.method_52979((byte[])skylightData.get());
        } else {
            skylightData = Optional.empty();
        }
        int blockEntityCount = buffer.method_10816();
        ArrayList<BlockEntityData> blockEntities = new ArrayList<BlockEntityData>(blockEntityCount);
        for (int index = 0; index < blockEntityCount; ++index) {
            blockEntities.add(BlockEntityData.read(buffer));
        }
        return new ChunkSectionLoadPacket(sectionX, sectionY, sectionZ, (Either<byte[], class_2826>)Either.right((Object)section), skylightData, blockEntities);
    }

    public void write(class_2540 buffer) {
        buffer.method_53002(this.sectionX).method_53002(this.sectionY).method_53002(this.sectionZ);
        buffer.method_52983((byte[])this.sectionData.left().orElseThrow()).method_52964(this.skylightData.isPresent());
        if (this.skylightData.isPresent()) {
            buffer.method_52983(this.skylightData.get());
        }
        buffer.method_10804(this.blockEntities.size());
        for (BlockEntityData data : this.blockEntities) {
            data.write(buffer);
        }
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public static void send(class_3222 player, class_2818 chunk, int sectionY) {
        int sectionX = chunk.method_12004().field_9181;
        int sectionZ = chunk.method_12004().field_9180;
        class_2826 section = chunk.method_38259(chunk.method_31603(sectionY));
        ByteBuf buffer = Unpooled.buffer();
        section.method_12257(new class_2540(buffer));
        byte[] sectionData = new byte[buffer.writerIndex()];
        buffer.readBytes(sectionData);
        if (buffer.isReadable()) {
            throw new IllegalStateException("readable: " + buffer.readableBytes());
        }
        List<BlockEntityData> blockEntities = chunk.method_12214().values().stream().filter(blockEntity -> blockEntity.method_11016().method_10264() >> 4 == sectionY).map(BlockEntityData::create).toList();
        class_2804 skylight = chunk.method_12200().method_22336().method_15562(class_1944.field_9284).method_15544(class_4076.method_18676((int)sectionX, (int)sectionY, (int)sectionZ));
        Optional<byte[]> skylightData = skylight != null ? Optional.of((byte[])skylight.method_12137().clone()) : Optional.empty();
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)new ChunkSectionLoadPacket(sectionX, sectionY, sectionZ, (Either<byte[], class_2826>)Either.left((Object)sectionData), skylightData, blockEntities));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void process() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2818 chunk = (class_2818)world.method_8402(this.sectionX, this.sectionZ, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        chunk.method_12006()[chunk.method_31603((int)this.sectionY)] = (class_2826)this.sectionData.right().orElseThrow();
        for (BlockEntityData blockEntityData : this.blockEntities) {
            int z;
            int y;
            int x = chunk.method_12004().method_8326() | blockEntityData.packedXZ & 0xF;
            class_2586 blockEntity = chunk.method_12201(new class_2338(x, y = blockEntityData.y, z = chunk.method_12004().method_8328() | blockEntityData.packedXZ >>> 4 & 0xF), class_2818.class_2819.field_12860);
            if (blockEntity == null || blockEntityData.nbt == null || blockEntity.method_11017() != blockEntityData.type) continue;
            blockEntity.method_11014(blockEntityData.nbt);
        }
        if (this.skylightData.isPresent()) {
            class_4076 sectionPos = class_4076.method_18676((int)this.sectionX, (int)this.sectionY, (int)this.sectionZ);
            world.method_22336().method_15558(class_1944.field_9284, sectionPos, new class_2804((byte[])this.skylightData.get().clone()));
            world.method_22336().method_15551(sectionPos, ((class_2826)this.sectionData.right().orElseThrow()).method_38292());
        }
        world.method_18113(this.sectionX, this.sectionY, this.sectionZ);
        ((VertigoClientEvents.Load)VertigoClientEvents.SECTION_LOADED.invoker()).onSectionLoaded(this.sectionX, this.sectionY, this.sectionZ);
    }

    public record BlockEntityData(byte packedXZ, int y, class_2591<?> type, @Nullable class_2487 nbt) {
        public static BlockEntityData read(class_2540 buffer) {
            return new BlockEntityData(buffer.readByte(), buffer.readInt(), (class_2591)buffer.method_42064((class_2359)class_7923.field_41181), buffer.method_10798());
        }

        public void write(class_2540 buffer) {
            buffer.method_52997((int)this.packedXZ).method_53002(this.y);
            buffer.method_42065((class_2359)class_7923.field_41181, this.type);
            buffer.method_10794((class_2520)this.nbt);
        }

        public static BlockEntityData create(class_2586 blockEntity) {
            class_2591 type = blockEntity.method_11017();
            class_2487 nbt = blockEntity.method_16887();
            class_2338 pos = blockEntity.method_11016();
            int packedXZ = (pos.method_10260() & 0xF) << 4 | pos.method_10263() & 0xF;
            int y = pos.method_10264();
            return new BlockEntityData((byte)packedXZ, y, type, nbt);
        }
    }
}

