/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo;

import builderb0y.vertigo.TrackingManager;
import builderb0y.vertigo.VersionUtil;
import builderb0y.vertigo.api.VertigoClientEvents;
import builderb0y.vertigo.api.VertigoServerEvents;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3222;
import net.minecraft.class_5539;
import org.jetbrains.annotations.Nullable;

public class ChunkTrackingManager
extends TrackingManager {
    public final LongOpenHashSet loadedChunks = new LongOpenHashSet(256);

    public ChunkTrackingManager() {
    }

    public ChunkTrackingManager(class_3222 player) {
    }

    @Override
    public void clear() {
        this.loadedChunks.clear();
    }

    @Override
    public boolean isLoaded(int sectionX, int sectionY, int sectionZ) {
        return this.loadedChunks.contains(class_1923.method_8331((int)sectionX, (int)sectionZ));
    }

    @Override
    @Nullable
    public TrackingManager.LoadedRange getLoadedRange(int chunkX, int chunkZ) {
        boolean loaded = this.loadedChunks.contains(class_1923.method_8331((int)chunkX, (int)chunkZ));
        return loaded ? sectionY -> true : null;
    }

    @Override
    public void update(class_3222 player) {
    }

    @Override
    public void onChunkLoaded(class_3222 player, int chunkX, int chunkZ) {
        this.loadedChunks.add(class_1923.method_8331((int)chunkX, (int)chunkZ));
        int minSection = VersionUtil.sectionMinYInclusive((class_5539)VersionUtil.getWorld((class_1297)player));
        int maxSection = VersionUtil.sectionMaxYExclusive((class_5539)VersionUtil.getWorld((class_1297)player));
        for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
            ((VertigoServerEvents.Load)VertigoServerEvents.SECTION_LOADED.invoker()).onSectionLoaded(player, chunkX, sectionY, chunkZ);
        }
    }

    @Override
    public void onChunkUnloaded(class_3222 player, int chunkX, int chunkZ) {
        this.loadedChunks.remove(class_1923.method_8331((int)chunkX, (int)chunkZ));
        int minSection = VersionUtil.sectionMinYInclusive((class_5539)VersionUtil.getWorld((class_1297)player));
        int maxSection = VersionUtil.sectionMaxYExclusive((class_5539)VersionUtil.getWorld((class_1297)player));
        for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
            ((VertigoServerEvents.Unload)VertigoServerEvents.SECTION_UNLOADED.invoker()).onSectionUnloaded(player, chunkX, sectionY, chunkZ);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onChunkLoadedClient(class_2818 chunk) {
        this.loadedChunks.add(chunk.method_12004().method_8324());
        int minSection = VersionUtil.sectionMinYInclusive((class_5539)chunk);
        int maxSection = VersionUtil.sectionMaxYExclusive((class_5539)chunk);
        for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
            ((VertigoClientEvents.Load)VertigoClientEvents.SECTION_LOADED.invoker()).onSectionLoaded(chunk.method_12004().field_9181, sectionY, chunk.method_12004().field_9180);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onChunkUnloadedClient(class_2818 chunk) {
        this.loadedChunks.remove(chunk.method_12004().method_8324());
        int minSection = VersionUtil.sectionMinYInclusive((class_5539)chunk);
        int maxSection = VersionUtil.sectionMaxYExclusive((class_5539)chunk);
        for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
            ((VertigoClientEvents.Unload)VertigoClientEvents.SECTION_UNLOADED.invoker()).onSectionUnloaded(chunk.method_12004().field_9181, sectionY, chunk.method_12004().field_9180);
        }
    }

    @Override
    public void onLightingChanged(class_2338 pos) {
    }
}

