/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo;

import builderb0y.vertigo.TrackingManager;
import builderb0y.vertigo.VersionUtil;
import builderb0y.vertigo.api.VertigoClientEvents;
import builderb0y.vertigo.api.VertigoServerEvents;
import builderb0y.vertigo.compat.ValkyrienSkiesCompat;
import builderb0y.vertigo.networking.ChunkSectionLoadPacket;
import builderb0y.vertigo.networking.ChunkSectionUnloadPacket;
import builderb0y.vertigo.networking.LoadRangePacket;
import builderb0y.vertigo.networking.SkylightUpdatePacket;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.BitSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3222;
import net.minecraft.class_5539;
import org.jetbrains.annotations.Nullable;

public class SectionTrackingManager
extends TrackingManager {
    public final Long2ObjectMap<ChunkState> chunkBounds = new Long2ObjectOpenHashMap(256);
    public final LongOpenHashSet skylightUpdates = new LongOpenHashSet();
    public int previousSectionY;
    public int previousViewDistance;

    public SectionTrackingManager() {
    }

    public SectionTrackingManager(class_3222 player) {
        this.previousSectionY = player.method_31478() >> 4;
        this.previousViewDistance = VersionUtil.getViewDistance(player);
    }

    @Override
    public void clear() {
        this.chunkBounds.clear();
        this.skylightUpdates.clear();
    }

    @Override
    public boolean isLoaded(int sectionX, int sectionY, int sectionZ) {
        ChunkState bound = (ChunkState)this.chunkBounds.get(class_1923.method_8331((int)sectionX, (int)sectionZ));
        return bound != null && bound.isLoaded(sectionY);
    }

    @Override
    @Nullable
    public TrackingManager.LoadedRange getLoadedRange(int chunkX, int chunkZ) {
        return (TrackingManager.LoadedRange)this.chunkBounds.get(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    @Override
    public void update(class_3222 player) {
        if (this.previousSectionY != player.method_31478() >> 4 || this.previousViewDistance != VersionUtil.getViewDistance(player)) {
            this.doUpdate(player);
            this.previousSectionY = player.method_31478() >> 4;
            this.previousViewDistance = VersionUtil.getViewDistance(player);
        }
        if (!this.skylightUpdates.isEmpty()) {
            this.updateLight(player);
            this.skylightUpdates.clear();
        }
    }

    public void doUpdate(class_3222 player) {
        int playerCenterY = player.method_31478() >> 4;
        int range = VersionUtil.getViewDistance(player);
        ObjectIterator iterator = this.chunkBounds.long2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            int chunkZ;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            int chunkX = class_1923.method_8325((long)entry.getLongKey());
            if (ValkyrienSkiesCompat.isInShipyard(chunkX, chunkZ = class_1923.method_8332((long)entry.getLongKey()))) continue;
            class_2818 chunk = (class_2818)player.method_37908().method_8402(chunkX, chunkZ, class_2806.field_12803, false);
            if (chunk == null) {
                iterator.remove();
                continue;
            }
            boolean changed = false;
            ChunkState bound = (ChunkState)entry.getValue();
            if (bound.maxY < playerCenterY - range || bound.minY > playerCenterY + range) {
                int sectionY;
                for (sectionY = bound.minY; sectionY <= bound.maxY; ++sectionY) {
                    ((VertigoServerEvents.Unload)VertigoServerEvents.SECTION_UNLOADED.invoker()).onSectionUnloaded(player, chunkX, bound.maxY, chunkZ);
                    ChunkSectionUnloadPacket.send(player, chunkX, bound.maxY, chunkZ);
                }
                bound.minY = Math.max(playerCenterY - range, VersionUtil.sectionMinYInclusive((class_5539)chunk));
                bound.maxY = Math.min(playerCenterY + range, VersionUtil.sectionMaxYInclusive((class_5539)chunk));
                for (sectionY = bound.minY; sectionY <= bound.maxY; ++sectionY) {
                    ChunkSectionLoadPacket.send(player, chunk, sectionY);
                    ((VertigoServerEvents.Load)VertigoServerEvents.SECTION_LOADED.invoker()).onSectionLoaded(player, chunkX, bound.maxY, chunkZ);
                }
                changed = true;
            } else {
                while (bound.maxY < Math.min(playerCenterY + range, VersionUtil.sectionMaxYInclusive((class_5539)chunk))) {
                    ++bound.maxY;
                    ChunkSectionLoadPacket.send(player, chunk, bound.maxY);
                    ((VertigoServerEvents.Load)VertigoServerEvents.SECTION_LOADED.invoker()).onSectionLoaded(player, chunkX, bound.maxY, chunkZ);
                    changed = true;
                }
                while (bound.minY > Math.max(playerCenterY - range, VersionUtil.sectionMinYInclusive((class_5539)chunk))) {
                    --bound.minY;
                    ChunkSectionLoadPacket.send(player, chunk, bound.minY);
                    ((VertigoServerEvents.Load)VertigoServerEvents.SECTION_LOADED.invoker()).onSectionLoaded(player, chunkX, bound.minY, chunkZ);
                    changed = true;
                }
                while (bound.maxY > playerCenterY + range + 1) {
                    ((VertigoServerEvents.Unload)VertigoServerEvents.SECTION_UNLOADED.invoker()).onSectionUnloaded(player, chunkX, bound.maxY, chunkZ);
                    ChunkSectionUnloadPacket.send(player, chunkX, bound.maxY, chunkZ);
                    --bound.maxY;
                    changed = true;
                }
                while (bound.minY < playerCenterY - range - 1) {
                    ((VertigoServerEvents.Unload)VertigoServerEvents.SECTION_UNLOADED.invoker()).onSectionUnloaded(player, chunkX, bound.minY, chunkZ);
                    ChunkSectionUnloadPacket.send(player, chunkX, bound.minY, chunkZ);
                    ++bound.minY;
                    changed = true;
                }
            }
            if (!changed) continue;
            LoadRangePacket.send(player, chunk.method_12004().field_9181, chunk.method_12004().field_9180, bound.minY, bound.maxY);
        }
    }

    public void updateLight(class_3222 player) {
        LongIterator iterator = this.skylightUpdates.longIterator();
        while (iterator.hasNext()) {
            ChunkState info;
            long chunkPos = iterator.nextLong();
            if (ValkyrienSkiesCompat.isInShipyard(class_1923.method_8325((long)chunkPos), class_1923.method_8332((long)chunkPos)) || (info = (ChunkState)this.chunkBounds.get(chunkPos)) == null) continue;
            int chunkX = class_1923.method_8325((long)chunkPos);
            int chunkZ = class_1923.method_8332((long)chunkPos);
            SkylightUpdatePacket.send(player, chunkX, chunkZ, info.skylightMask);
            info.skylightMask.clear();
        }
    }

    @Override
    public void onChunkLoaded(class_3222 player, int chunkX, int chunkZ) {
        ChunkState bound = (ChunkState)this.chunkBounds.computeIfAbsent(class_1923.method_8331((int)chunkX, (int)chunkZ), packedPos -> new ChunkState());
        if (ValkyrienSkiesCompat.isInShipyard(chunkX, chunkZ)) {
            bound.minY = VersionUtil.sectionMinYInclusive((class_5539)player.method_37908());
            bound.maxY = VersionUtil.sectionMaxYInclusive((class_5539)player.method_37908());
            LoadRangePacket.send(player, chunkX, chunkZ, bound.minY, bound.maxY);
        } else {
            int playerCenterY = player.method_31478() >> 4;
            bound.minY = Math.max(playerCenterY - VersionUtil.getViewDistance(player), VersionUtil.sectionMinYInclusive((class_5539)player.method_37908()));
            bound.maxY = Math.min(playerCenterY + VersionUtil.getViewDistance(player), VersionUtil.sectionMaxYInclusive((class_5539)player.method_37908()));
            LoadRangePacket.send(player, chunkX, chunkZ, bound.minY, bound.maxY);
            BitSet everywhere = new BitSet(256);
            everywhere.set(0, 256);
            SkylightUpdatePacket.send(player, chunkX, chunkZ, everywhere);
        }
        for (int sectionY = bound.minY; sectionY <= bound.maxY; ++sectionY) {
            ((VertigoServerEvents.Load)VertigoServerEvents.SECTION_LOADED.invoker()).onSectionLoaded(player, chunkX, sectionY, chunkZ);
        }
    }

    @Override
    public void onChunkUnloaded(class_3222 player, int chunkX, int chunkZ) {
        ChunkState bounds = (ChunkState)this.chunkBounds.remove(class_1923.method_8331((int)chunkX, (int)chunkZ));
        if (bounds != null) {
            for (int sectionY = bounds.minY; sectionY <= bounds.maxY; ++sectionY) {
                ((VertigoServerEvents.Unload)VertigoServerEvents.SECTION_UNLOADED.invoker()).onSectionUnloaded(player, chunkX, sectionY, chunkZ);
            }
            LoadRangePacket.sendUnload(player, chunkX, chunkZ);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onChunkLoadedClient(class_2818 chunk) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onChunkUnloadedClient(class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        ChunkState state = (ChunkState)this.chunkBounds.remove(chunkPos.method_8324());
        if (state != null) {
            for (int sectionY = state.minY; sectionY <= state.maxY; ++sectionY) {
                ((VertigoClientEvents.Unload)VertigoClientEvents.SECTION_UNLOADED.invoker()).onSectionUnloaded(chunkPos.field_9181, sectionY, chunkPos.field_9180);
            }
        }
    }

    @Override
    public void onLightingChanged(class_2338 pos) {
        long chunkPos = class_1923.method_37232((class_2338)pos);
        ChunkState info = (ChunkState)this.chunkBounds.get(chunkPos);
        if (info != null) {
            this.skylightUpdates.add(chunkPos);
            info.skylightMask.set((pos.method_10260() & 0xF) << 4 | pos.method_10263() & 0xF);
        }
    }

    public static class ChunkState
    implements TrackingManager.LoadedRange {
        public int minY;
        public int maxY;
        public final BitSet skylightMask = new BitSet(256);

        @Override
        public boolean isLoaded(int sectionY) {
            return sectionY >= this.minY && sectionY <= this.maxY;
        }
    }
}

