/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo.api;

import builderb0y.vertigo.TrackingManager;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;

public class VertigoAPI {
    public static boolean isSectionLoaded(class_1657 player, int sectionX, int sectionY, int sectionZ) {
        if (player.method_37908().field_9236) {
            return VertigoAPI.isSectionLoadedClient(player, sectionX, sectionY, sectionZ);
        }
        TrackingManager manager = TrackingManager.PLAYERS.get(player);
        return manager != null && manager.isLoaded(sectionX, sectionY, sectionZ);
    }

    @Environment(value=EnvType.CLIENT)
    private static boolean isSectionLoadedClient(class_1657 player, int sectionX, int sectionY, int sectionZ) {
        if (player == class_310.method_1551().field_1724) {
            return TrackingManager.CLIENT.isLoaded(sectionX, sectionY, sectionZ);
        }
        return false;
    }

    public static boolean isSectionLoaded(class_1657 player, class_4076 pos) {
        return VertigoAPI.isSectionLoaded(player, pos.method_18674(), pos.method_18683(), pos.method_18687());
    }

    public static boolean isBlockLoaded(class_1657 player, int blockX, int blockY, int blockZ) {
        return VertigoAPI.isSectionLoaded(player, blockX >> 4, blockY >> 4, blockZ >> 4);
    }

    public static boolean isBlockLoaded(class_1657 player, class_2338 pos) {
        return VertigoAPI.isBlockLoaded(player, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static Stream<class_3222> getPlayersTrackingSection(class_3218 world, int sectionX, int sectionY, int sectionZ) {
        if (TrackingManager.PLAYERS.isEmpty()) {
            return Stream.empty();
        }
        List players = world.method_18456();
        if (players.isEmpty()) {
            return Stream.empty();
        }
        return players.stream().filter(player -> {
            TrackingManager manager = TrackingManager.PLAYERS.get(player);
            return manager != null && manager.isLoaded(sectionX, sectionY, sectionZ);
        });
    }

    public static Stream<class_3222> getPlayersTrackingSection(class_3218 world, class_4076 pos) {
        return VertigoAPI.getPlayersTrackingSection(world, pos.method_18674(), pos.method_18683(), pos.method_18687());
    }

    public static Stream<class_3222> getPlayersTrackingBlock(class_3218 world, int blockX, int blockY, int blockZ) {
        return VertigoAPI.getPlayersTrackingSection(world, blockX >> 4, blockY >> 4, blockZ >> 4);
    }

    public static Stream<class_3222> getPlayersTrackingBlock(class_3218 world, class_2338 pos) {
        return VertigoAPI.getPlayersTrackingBlock(world, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static boolean isTrackingSections(class_1657 player) {
        if (player.method_37908().field_9236) {
            return VertigoAPI.isTrackingSectionsClient(player);
        }
        TrackingManager trackingManager = TrackingManager.PLAYERS.get(player);
        return trackingManager != null && trackingManager.otherSideHasVertigoInstalled();
    }

    @Environment(value=EnvType.CLIENT)
    private static boolean isTrackingSectionsClient(class_1657 player) {
        if (player == class_310.method_1551().field_1724) {
            return TrackingManager.CLIENT.otherSideHasVertigoInstalled();
        }
        return false;
    }
}

