/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo.networking;

import builderb0y.vertigo.VersionUtil;
import builderb0y.vertigo.Vertigo;
import builderb0y.vertigo.api.VertigoClientEvents;
import builderb0y.vertigo.networking.VertigoNetworking;
import builderb0y.vertigo.networking.VertigoS2CPacket;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11352;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record ChunkSectionLoadPacket(int sectionX, int sectionY, int sectionZ, Either<byte[], class_2826> sectionData, Optional<byte[]> skylightData, List<BlockEntityData> blockEntities) implements VertigoS2CPacket
{
    public static final class_2960 PACKET_ID = Vertigo.modID("section_load");
    public static final class_9139<class_9129, ChunkSectionLoadPacket> PACKET_CODEC = class_9139.method_58025((class_9139)class_9135.field_49675, ChunkSectionLoadPacket::sectionX, (class_9139)class_9135.field_49675, ChunkSectionLoadPacket::sectionY, (class_9139)class_9135.field_49675, ChunkSectionLoadPacket::sectionZ, (class_9139)class_9139.method_56438((either, buffer) -> buffer.method_52983((byte[])either.left().orElseThrow()), buffer -> {
        class_2826 section = VersionUtil.newEmptyChunkSection(buffer.method_56349());
        section.method_12258((class_2540)buffer);
        return Either.right((Object)section);
    }), ChunkSectionLoadPacket::sectionData, (class_9139)class_9135.method_56382(VertigoNetworking.fixedSizeByteArray(2048)), ChunkSectionLoadPacket::skylightData, (class_9139)BlockEntityData.PACKET_CODEC.method_56433(class_9135.method_58000((int)4096)), ChunkSectionLoadPacket::blockEntities, ChunkSectionLoadPacket::new);
    public static final class_8710.class_9154<ChunkSectionLoadPacket> ID = new class_8710.class_9154(PACKET_ID);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void send(class_3222 player, class_2818 chunk, int sectionY) {
        int sectionX = chunk.method_12004().field_9181;
        int sectionZ = chunk.method_12004().field_9180;
        class_2826 section = chunk.method_38259(chunk.method_31603(sectionY));
        ByteBuf buffer = Unpooled.buffer();
        section.method_12257(new class_2540(buffer));
        byte[] sectionData = new byte[buffer.writerIndex()];
        buffer.readBytes(sectionData);
        if (buffer.isReadable()) {
            throw new IllegalStateException("readable: " + buffer.readableBytes());
        }
        List<BlockEntityData> blockEntities = chunk.method_12214().values().stream().filter(blockEntity -> blockEntity.method_11016().method_10264() >> 4 == sectionY).map(BlockEntityData::create).toList();
        class_2804 skylight = chunk.method_12200().method_22336().method_15562(class_1944.field_9284).method_15544(class_4076.method_18676((int)sectionX, (int)sectionY, (int)sectionZ));
        Optional<byte[]> skylightData = skylight != null ? Optional.of((byte[])skylight.method_12137().clone()) : Optional.empty();
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ChunkSectionLoadPacket(sectionX, sectionY, sectionZ, (Either<byte[], class_2826>)Either.left((Object)sectionData), skylightData, blockEntities));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void process() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2818 chunk = (class_2818)world.method_8402(this.sectionX, this.sectionZ, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        chunk.method_12006()[chunk.method_31603((int)this.sectionY)] = (class_2826)this.sectionData.right().orElseThrow();
        for (BlockEntityData blockEntityData : this.blockEntities) {
            int z;
            int y;
            int x = chunk.method_12004().method_8326() | blockEntityData.packedXZ & 0xF;
            class_2586 blockEntity = chunk.method_12201(new class_2338(x, y = blockEntityData.y, z = chunk.method_12004().method_8328() | blockEntityData.packedXZ >>> 4 & 0xF), class_2818.class_2819.field_12860);
            if (blockEntity == null || blockEntityData.nbt == null || blockEntity.method_11017() != blockEntityData.type) continue;
            try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Vertigo.LOGGER);){
                blockEntity.method_58690(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)blockEntityData.nbt));
            }
        }
        world.method_2935().field_16246.method_65523(chunk);
        if (this.skylightData.isPresent()) {
            class_4076 sectionPos = class_4076.method_18676((int)this.sectionX, (int)this.sectionY, (int)this.sectionZ);
            world.method_22336().method_15558(class_1944.field_9284, sectionPos, new class_2804((byte[])this.skylightData.get().clone()));
            world.method_22336().method_15551(sectionPos, ((class_2826)this.sectionData.right().orElseThrow()).method_38292());
        }
        world.method_18113(this.sectionX, this.sectionY, this.sectionZ);
        ((VertigoClientEvents.Load)VertigoClientEvents.SECTION_LOADED.invoker()).onSectionLoaded(this.sectionX, this.sectionY, this.sectionZ);
    }

    public record BlockEntityData(byte packedXZ, int y, class_2591<?> type, @Nullable class_2487 nbt) {
        public static final class_9139<class_9129, BlockEntityData> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_48548, BlockEntityData::packedXZ, (class_9139)class_9135.field_49675, BlockEntityData::y, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41255), BlockEntityData::type, (class_9139)class_9135.method_57998(() -> class_2505.method_53899((long)0x200000L)), BlockEntityData::nbt, BlockEntityData::new);

        public static BlockEntityData create(class_2586 blockEntity) {
            class_2591 type = blockEntity.method_11017();
            class_2487 nbt = blockEntity.method_16887((class_7225.class_7874)blockEntity.method_10997().method_30349());
            class_2338 pos = blockEntity.method_11016();
            int packedXZ = (pos.method_10260() & 0xF) << 4 | pos.method_10263() & 0xF;
            int y = pos.method_10264();
            return new BlockEntityData((byte)packedXZ, y, type, nbt);
        }
    }
}

