/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.vertigo.networking;

import builderb0y.vertigo.TrackingManager;
import builderb0y.vertigo.Vertigo;
import builderb0y.vertigo.compat.ScalableLuxCompat;
import builderb0y.vertigo.mixin.ChunkSkyLight_Accessors;
import builderb0y.vertigo.networking.VertigoS2CPacket;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3562;
import net.minecraft.class_638;
import net.minecraft.class_6490;
import net.minecraft.class_8528;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record SkylightUpdatePacket(int chunkX, int chunkZ, IntArrayList skyPositions) implements VertigoS2CPacket
{
    public static final class_2960 PACKET_ID = Vertigo.modID("skylight_update");
    public static final class_9139<ByteBuf, SkylightUpdatePacket> PACKET_CODEC = class_9139.method_56438(SkylightUpdatePacket::write, SkylightUpdatePacket::read);
    public static final class_8710.class_9154<SkylightUpdatePacket> ID = new class_8710.class_9154(PACKET_ID);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static SkylightUpdatePacket read(ByteBuf buffer) {
        IntArrayList skylightPositions;
        int chunkX = buffer.readInt();
        int chunkZ = buffer.readInt();
        if (buffer.readBoolean()) {
            BitSet bits = BitSet.valueOf(new long[]{buffer.readLong(), buffer.readLong(), buffer.readLong(), buffer.readLong()});
            skylightPositions = new IntArrayList(bits.cardinality());
            int index = -1;
            while ((index = bits.nextSetBit(index + 1)) >= 0) {
                skylightPositions.add(SkylightUpdatePacket.packSkylightPos(index, buffer.readUnsignedShort()));
            }
        } else {
            int count = buffer.readUnsignedByte();
            skylightPositions = new IntArrayList(count);
            for (int index = 0; index < count; ++index) {
                skylightPositions.add(SkylightUpdatePacket.packSkylightPos(buffer.readUnsignedByte(), buffer.readUnsignedShort()));
            }
        }
        return new SkylightUpdatePacket(chunkX, chunkZ, skylightPositions);
    }

    public void write(ByteBuf buffer) {
        buffer.writeInt(this.chunkX).writeInt(this.chunkZ);
        if (this.skyPositions.size() >= 32) {
            buffer.writeBoolean(true);
            BitSet bits = new BitSet(256);
            int size = this.skyPositions.size();
            for (int index = 0; index < size; ++index) {
                bits.set(SkylightUpdatePacket.unpackIndex(this.skyPositions.getInt(index)));
            }
            int count = 0;
            for (long value : bits.toLongArray()) {
                buffer.writeLong(value);
                ++count;
            }
            while (count++ < 4) {
                buffer.writeLong(0L);
            }
            int size2 = this.skyPositions.size();
            for (int index = 0; index < size2; ++index) {
                buffer.writeShort(SkylightUpdatePacket.unpackRelativeY(this.skyPositions.getInt(index)));
            }
        } else {
            buffer.writeBoolean(false);
            buffer.writeByte(this.skyPositions.size());
            int size = this.skyPositions.size();
            for (int index = 0; index < size; ++index) {
                int packed = this.skyPositions.getInt(index);
                buffer.writeByte(SkylightUpdatePacket.unpackIndex(packed)).writeShort(SkylightUpdatePacket.unpackRelativeY(packed));
            }
        }
    }

    public static int packSkylightPos(int index, int relativeY) {
        return (index & 0xFF) << 16 | relativeY & 0xFFFF;
    }

    public static int unpackIndex(int packed) {
        return packed >>> 16 & 0xFF;
    }

    public static int unpackRelativeY(int packed) {
        return packed & 0xFFFF;
    }

    public static void send(class_3222 player, int chunkX, int chunkZ, BitSet mask) {
        class_2818 chunk = (class_2818)player.method_51469().method_8402(chunkX, chunkZ, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        class_6490 palette = ((ChunkSkyLight_Accessors)chunk.method_12018()).vertigo_getPalette();
        IntArrayList queuedPositions = new IntArrayList(mask.cardinality());
        int index = -1;
        while ((index = mask.nextSetBit(index + 1)) >= 0) {
            queuedPositions.add(SkylightUpdatePacket.packSkylightPos(index, palette.method_15211(index)));
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SkylightUpdatePacket(chunk.method_12004().field_9181, chunk.method_12004().field_9180, queuedPositions));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void process() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2818 chunk = (class_2818)world.method_8402(this.chunkX, this.chunkZ, class_2806.field_12803, false);
        if (chunk == null) {
            return;
        }
        TrackingManager.LoadedRange range = TrackingManager.CLIENT.getLoadedRange(this.chunkX, this.chunkZ);
        if (range == null) {
            return;
        }
        class_8528 skylight = chunk.method_12018();
        ChunkSkyLight_Accessors accessors = (ChunkSkyLight_Accessors)skylight;
        class_3562 lighting = world.method_22336().method_15562(class_1944.field_9284);
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int chunkMinY = accessors.vertigo_getMinY();
        int size = this.skyPositions.size();
        for (int index = 0; index < size; ++index) {
            int pos = this.skyPositions.getInt(index);
            int localIndex = SkylightUpdatePacket.unpackIndex(pos);
            int newRelativeY = SkylightUpdatePacket.unpackRelativeY(pos);
            int oldRelativeY = accessors.vertigo_getPalette().method_15214(localIndex, newRelativeY);
            int x = chunk.method_12004().method_8326() | localIndex & 0xF;
            int z = chunk.method_12004().method_8328() | localIndex >>> 4;
            if (ScalableLuxCompat.scalableLuxInstalled) {
                if (oldRelativeY == newRelativeY) continue;
                --newRelativeY;
                if (!range.isLoaded(--oldRelativeY + chunkMinY >> 4)) {
                    world.method_8501((class_2338)mutablePos.method_10103(x, oldRelativeY + chunkMinY, z), class_2246.field_10124.method_9564());
                }
                if (range.isLoaded(newRelativeY + chunkMinY >> 4)) continue;
                world.method_8501((class_2338)mutablePos.method_10103(x, newRelativeY + chunkMinY, z), class_2246.field_10340.method_9564());
                continue;
            }
            lighting.method_15513((class_2338)mutablePos.method_10103(x, newRelativeY + chunkMinY, z));
        }
    }
}

