/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine;

import net.godlycow.org.shopengine.commands.ShopCommand;
import net.godlycow.org.shopengine.config.ConfigManager;
import net.godlycow.org.shopengine.config.ItemManager;
import net.godlycow.org.shopengine.config.MessageManager;
import net.godlycow.org.shopengine.config.SectionManager;
import net.godlycow.org.shopengine.economy.EconomyManager;
import net.godlycow.org.shopengine.listeners.ShopListener;
import net.godlycow.org.shopengine.player.PlayerDataManager;
import net.godlycow.org.shopengine.shop.DynamicPricingManager;
import net.godlycow.org.shopengine.shop.ShopManager;
import net.godlycow.org.shopengine.shop.StockManager;
import net.godlycow.org.shopengine.utils.SignInputManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ShopEngine
extends JavaPlugin {
    private static ShopEngine instance;
    private MiniMessage miniMessage;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private SectionManager sectionManager;
    private ItemManager itemManager;
    private ShopManager shopManager;
    private DynamicPricingManager dynamicPricingManager;
    private EconomyManager economyManager;
    private PlayerDataManager playerDataManager;
    private SignInputManager signInputManager;
    private StockManager stockManager;

    public void onEnable() {
        instance = this;
        this.miniMessage = MiniMessage.miniMessage();
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.sectionManager = new SectionManager(this);
        this.itemManager = new ItemManager(this);
        this.playerDataManager = new PlayerDataManager(this);
        this.signInputManager = new SignInputManager(this);
        this.stockManager = new StockManager();
        if (!this.setupEconomy()) {
            this.getLogger().severe("No Vault-supported economy plugin found!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveResource("help.yml", false);
        this.dynamicPricingManager = new DynamicPricingManager(this);
        this.shopManager = new ShopManager(this);
        this.getCommand("shop").setExecutor((CommandExecutor)new ShopCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new ShopListener(this), (Plugin)this);
        this.getLogger().info("ShopEngine has been enabled!");
        this.getLogger().info("Dynamic Pricing: " + (this.configManager.isDynamicPricingEnabled() ? "ENABLED" : "DISABLED"));
    }

    public void onDisable() {
        if (this.dynamicPricingManager != null) {
            this.dynamicPricingManager.savePrices();
        }
        if (this.economyManager != null) {
            this.economyManager.cleanup();
        }
        if (this.playerDataManager != null) {
            this.playerDataManager.saveAll();
        }
        this.getLogger().info("ShopEngine has been disabled!");
    }

    private boolean setupEconomy() {
        this.economyManager = new EconomyManager(this);
        return this.economyManager.setup();
    }

    public static ShopEngine getInstance() {
        return instance;
    }

    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public SectionManager getSectionManager() {
        return this.sectionManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public DynamicPricingManager getDynamicPricingManager() {
        return this.dynamicPricingManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public SignInputManager getSignInputManager() {
        return this.signInputManager;
    }

    public StockManager getStockManager() {
        return this.stockManager;
    }
}

