/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.shop.ShopItem;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ItemManager {
    private final ShopEngine plugin;
    private final File itemsFolder;
    private final Map<String, List<ShopItem>> itemCache = new HashMap<String, List<ShopItem>>();

    public ItemManager(ShopEngine plugin) {
        this.plugin = plugin;
        this.itemsFolder = new File(plugin.getDataFolder(), "items");
        if (!this.itemsFolder.exists()) {
            this.itemsFolder.mkdirs();
            this.createDefaultItems();
        }
        this.loadItems();
    }

    private void createDefaultItems() {
        File foodItems;
        File mineralsItems;
        File blocksItems = new File(this.itemsFolder, "blocks.yml");
        if (!blocksItems.exists()) {
            this.plugin.saveResource("items/blocks.yml", false);
        }
        if (!(mineralsItems = new File(this.itemsFolder, "minerals.yml")).exists()) {
            this.plugin.saveResource("items/minerals.yml", false);
        }
        if (!(foodItems = new File(this.itemsFolder, "food.yml")).exists()) {
            this.plugin.saveResource("items/food.yml", false);
        }
    }

    public void loadItems() {
        this.itemCache.clear();
        File[] files = this.itemsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            this.plugin.getLogger().warning("No item files found in /items/ folder!");
            return;
        }
        for (File file : files) {
            try {
                String fileName = file.getName().replace(".yml", "");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                List<ShopItem> items = this.loadItemsFromFile((FileConfiguration)config, fileName);
                this.itemCache.put(fileName, items);
                this.plugin.getLogger().info("Loaded " + items.size() + " items from " + file.getName());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load item file: " + file.getName(), e);
            }
        }
    }

    private List<ShopItem> loadItemsFromFile(FileConfiguration config, String fileName) {
        ArrayList<ShopItem> items = new ArrayList<ShopItem>();
        for (String key : config.getKeys(false)) {
            ConfigurationSection itemData = config.getConfigurationSection(key);
            if (itemData == null) continue;
            try {
                ShopItem item = this.loadItem(key, itemData);
                items.add(item);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load item '" + key + "' in file '" + fileName + "': " + e.getMessage());
            }
        }
        return items;
    }

    private ShopItem loadItem(String key, ConfigurationSection itemData) {
        Material material = Material.matchMaterial((String)itemData.getString("material"));
        if (material == null) {
            throw new IllegalArgumentException("Invalid material: " + itemData.getString("material"));
        }
        String displayName = itemData.getString("display-name", "");
        int slot = itemData.getInt("slot");
        int page = itemData.getInt("page", 1) - 1;
        int amount = itemData.getInt("amount", 1);
        double buyPrice = itemData.getDouble("buy-price", -1.0);
        double sellPrice = itemData.getDouble("sell-price", -1.0);
        int stock = itemData.getInt("stock", -1);
        int customModelData = itemData.getInt("custom-model-data", -1);
        List lore = itemData.getStringList("lore");
        return new ShopItem(key, material, displayName, lore, slot, page, amount, buyPrice, sellPrice, stock, customModelData);
    }

    public List<ShopItem> getItemsForSection(String sectionFileName) {
        return this.itemCache.getOrDefault(sectionFileName, new ArrayList());
    }

    public void reload() {
        this.loadItems();
    }
}

