/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.shop.ShopItem;
import net.godlycow.org.shopengine.shop.ShopSection;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SectionManager {
    private final ShopEngine plugin;
    private final File sectionsFolder;
    private final Map<String, ShopSection> sectionCache = new HashMap<String, ShopSection>();

    public SectionManager(ShopEngine plugin) {
        this.plugin = plugin;
        this.sectionsFolder = new File(plugin.getDataFolder(), "sections");
        if (!this.sectionsFolder.exists()) {
            this.sectionsFolder.mkdirs();
            this.createDefaultSections();
        }
        this.loadSections();
    }

    private void createDefaultSections() {
        File foodFile;
        File mineralsFile;
        File blocksFile = new File(this.sectionsFolder, "blocks.yml");
        if (!blocksFile.exists()) {
            this.plugin.saveResource("sections/blocks.yml", false);
        }
        if (!(mineralsFile = new File(this.sectionsFolder, "minerals.yml")).exists()) {
            this.plugin.saveResource("sections/minerals.yml", false);
        }
        if (!(foodFile = new File(this.sectionsFolder, "food.yml")).exists()) {
            this.plugin.saveResource("sections/food.yml", false);
        }
    }

    public void loadSections() {
        this.sectionCache.clear();
        File[] files = this.sectionsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            this.plugin.getLogger().warning("No section files found in /sections/ folder!");
            return;
        }
        for (File file : files) {
            try {
                String sectionKey = file.getName().replace(".yml", "");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                ShopSection section = this.loadSectionFromConfig(sectionKey, (FileConfiguration)config);
                this.sectionCache.put(sectionKey, section);
                this.plugin.getLogger().info("Loaded section: " + sectionKey + " from " + file.getName());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load section file: " + file.getName(), e);
            }
        }
    }

    private ShopSection loadSectionFromConfig(String key, FileConfiguration config) {
        String displayName = config.getString("display-name", key);
        Material icon = Material.matchMaterial((String)config.getString("icon", "CHEST"));
        int slot = config.getInt("slot", 0);
        int page = config.getInt("page", 1) - 1;
        return new ShopSection(key, displayName, icon, slot, page, new ArrayList<ShopItem>());
    }

    public ShopSection getSection(String key) {
        return this.sectionCache.get(key);
    }

    public Map<String, ShopSection> getSections() {
        return new HashMap<String, ShopSection>(this.sectionCache);
    }

    public boolean hasSection(String key) {
        return this.sectionCache.containsKey(key);
    }

    public void reload() {
        this.loadSections();
    }
}

