/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.gui;

import java.util.List;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.player.PlayerDataManager;
import net.godlycow.org.shopengine.player.Transaction;
import net.godlycow.org.shopengine.utils.ItemBuilder;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class HistoryGUI
implements InventoryHolder {
    private final ShopEngine plugin;
    private final Player player;
    private final Inventory inventory;
    private int page = 0;
    private static final int ITEMS_PER_PAGE = 45;

    public HistoryGUI(ShopEngine plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)plugin.getMiniMessage().deserialize((Object)plugin.getMessageManager().getMessage("gui.history.title")));
        this.initialize();
    }

    private void initialize() {
        int index;
        PlayerDataManager.PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(this.player);
        List<Transaction> transactions = data.getRecentTransactions(1000);
        this.inventory.clear();
        if (transactions.isEmpty()) {
            ItemBuilder empty = new ItemBuilder(this.plugin, Material.BARRIER).name(this.plugin.getMessageManager().getMessage("gui.history.no-transactions"));
            this.inventory.setItem(22, empty.build());
            this.setupBackButton();
            return;
        }
        int totalPages = (int)Math.ceil((double)transactions.size() / 45.0);
        this.page = Math.min(this.page, Math.max(0, totalPages - 1));
        int startIndex = this.page * 45;
        for (int i = 0; i < 45 && (index = startIndex + i) < transactions.size(); ++i) {
            Transaction transaction = transactions.get(index);
            this.displayTransaction(i, transaction);
        }
        this.setupNavigation(totalPages);
        this.setupInfoPanel(transactions.size());
    }

    private void displayTransaction(int slot, Transaction transaction) {
        String action = transaction.isBuy() ? "PURCHASED" : "SOLD";
        ItemBuilder builder = new ItemBuilder(this.plugin, transaction.getMaterial()).name((transaction.isBuy() ? "<green>\u2713 " : "<red>\u2717 ") + action).amount(transaction.getAmount()).lore("<gray>Time: <white>" + transaction.getFormattedTime(), "<gray>Amount: <yellow>" + transaction.getAmount() + "x", "<gray>Price: <gold>$" + transaction.getPrice(), "", "<gray>Total: <gold>$" + transaction.getPrice() * (double)transaction.getAmount());
        this.inventory.setItem(slot, builder.build());
    }

    private void setupNavigation(int totalPages) {
        if (this.page > 0) {
            ItemBuilder prev = new ItemBuilder(this.plugin, Material.ARROW).name(this.plugin.getMessageManager().getMessage("gui.history.previous-page")).lore(this.plugin.getMessageManager().getMessage("gui.history.page-info").replace("<current>", String.valueOf(this.page + 1)).replace("<total>", String.valueOf(totalPages)));
            this.inventory.setItem(48, prev.build());
        }
        if (this.page < totalPages - 1) {
            ItemBuilder next = new ItemBuilder(this.plugin, Material.ARROW).name(this.plugin.getMessageManager().getMessage("gui.history.next-page")).lore(this.plugin.getMessageManager().getMessage("gui.history.page-info").replace("<current>", String.valueOf(this.page + 2)).replace("<total>", String.valueOf(totalPages)));
            this.inventory.setItem(50, next.build());
        }
        this.setupBackButton();
    }

    private void setupBackButton() {
        ItemBuilder back = new ItemBuilder(this.plugin, Material.BARRIER).name(this.plugin.getMessageManager().getMessage("gui.history.close")).lore(this.plugin.getMessageManager().getMessage("gui.history.close-lore"));
        this.inventory.setItem(49, back.build());
    }

    private void setupInfoPanel(int totalTransactions) {
        PlayerDataManager.PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(this.player);
        String totalMsg = this.plugin.getMessageManager().getMessage("gui.history.total-transactions").replace("<count>", String.valueOf(totalTransactions));
        String purchasesMsg = this.plugin.getMessageManager().getMessage("gui.history.purchases-count").replace("<count>", String.valueOf(this.countTransactions(data, true)));
        String salesMsg = this.plugin.getMessageManager().getMessage("gui.history.sales-count").replace("<count>", String.valueOf(this.countTransactions(data, false)));
        ItemBuilder stats = new ItemBuilder(this.plugin, Material.BOOK).name(this.plugin.getMessageManager().getMessage("gui.history.statistics")).lore(totalMsg, this.plugin.getMessageManager().getMessage("gui.history.recent-activity"), purchasesMsg, salesMsg);
        this.inventory.setItem(53, stats.build());
    }

    private long countTransactions(PlayerDataManager.PlayerData data, boolean isBuy) {
        return data.getTransactions().stream().filter(t -> t.isBuy() == isBuy).count();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 48 && this.page > 0) {
            --this.page;
            this.initialize();
        } else if (slot == 50) {
            ++this.page;
            this.initialize();
        } else if (slot == 49) {
            this.player.closeInventory();
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

