/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.gui;

import java.util.HashMap;
import java.util.Map;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.gui.SearchResultsGUI;
import net.godlycow.org.shopengine.player.Transaction;
import net.godlycow.org.shopengine.shop.ShopItem;
import net.godlycow.org.shopengine.shop.ShopSection;
import net.godlycow.org.shopengine.shop.StockManager;
import net.godlycow.org.shopengine.utils.ItemBuilder;
import net.godlycow.org.shopengine.utils.NumberUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ShopGUI
implements InventoryHolder {
    private final ShopEngine plugin;
    private final Player player;
    private final ShopSection section;
    private final int currentPage;
    private final Inventory inventory;
    private final Map<Integer, ShopItem> clickableItems = new HashMap<Integer, ShopItem>();
    private static final int CONTENT_SLOTS = 45;
    private static final int NAV_ROW_START = 45;

    public ShopGUI(ShopEngine plugin, Player player, ShopSection section, int page) {
        this.plugin = plugin;
        this.player = player;
        this.section = section;
        this.currentPage = page;
        String titleKey = section == null ? "gui.titles.main-shop" : "gui.titles.section";
        Object title = plugin.getMessageManager().getMessage(titleKey);
        if (section != null) {
            title = ((String)title).replace("<section>", section.getDisplayName());
        }
        title = (String)title + " <dark_gray>(Page " + (page + 1) + ")";
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)plugin.getMiniMessage().deserialize(title));
        this.initialize();
    }

    public ShopGUI(ShopEngine plugin, Player player, ShopSection section) {
        this(plugin, player, section, 0);
    }

    private void initialize() {
        this.clickableItems.clear();
        if (this.section == null) {
            for (ShopSection shopSection : this.plugin.getShopManager().getSections().values()) {
                if (shopSection.getPage() != this.currentPage) continue;
                ItemBuilder icon = new ItemBuilder(this.plugin, shopSection.getIcon()).name(shopSection.getDisplayName()).lore(this.plugin.getMessageManager().getMessage("gui.lore.click-to-view")).glow(true);
                this.inventory.setItem(shopSection.getSlot(), icon.build());
            }
        } else {
            for (ShopItem item : this.section.getItems()) {
                if (item.getPage() != this.currentPage) continue;
                this.plugin.getStockManager().initializeStock(item);
                double buyPrice = this.plugin.getDynamicPricingManager().getDynamicPrice(item, true);
                double sellPrice = this.plugin.getDynamicPricingManager().getDynamicPrice(item, false);
                int currentStock = this.plugin.getStockManager().getCurrentStock(item);
                ItemBuilder itemBuilder = new ItemBuilder(this.plugin, item.getMaterial()).name((String)(item.getDisplayName().isEmpty() ? "<white>" + NumberUtils.formatMaterialName(item.getMaterial()) : item.getDisplayName())).amount(item.getAmount());
                item.getLore().forEach(itemBuilder::lore);
                if (item.canBuy()) {
                    String buyMsg = this.plugin.getMessageManager().getMessage("gui.lore.buy-price");
                    itemBuilder.lore(buyMsg.replace("<price>", NumberUtils.format(buyPrice)));
                }
                if (item.canSell()) {
                    String sellMsg = this.plugin.getMessageManager().getMessage("gui.lore.sell-price");
                    itemBuilder.lore(sellMsg.replace("<price>", NumberUtils.format(sellPrice)));
                }
                if (item.getStock() > 0) {
                    String stockMsg = this.plugin.getMessageManager().getMessage("gui.lore.stock");
                    itemBuilder.lore(stockMsg.replace("<current>", String.valueOf(currentStock)));
                }
                if (this.plugin.getConfigManager().isDynamicPricingEnabled()) {
                    double multiplier = this.plugin.getDynamicPricingManager().getMultipliers().getOrDefault(item.getKey(), 1.0);
                    if (multiplier > 1.0) {
                        itemBuilder.lore(this.plugin.getMessageManager().getMessage("dynamic-prices.high"));
                    } else if (multiplier < 1.0) {
                        itemBuilder.lore(this.plugin.getMessageManager().getMessage("dynamic-prices.low"));
                    }
                }
                String balanceMsg = this.plugin.getMessageManager().getMessage("gui.lore.your-balance");
                itemBuilder.lore("");
                itemBuilder.lore(balanceMsg.replace("<balance>", NumberUtils.format(this.plugin.getEconomyManager().getBalance(this.player))));
                itemBuilder.lore("");
                if (item.canBuy() && item.canSell()) {
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.left-click-buy"));
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.right-click-sell"));
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.shift-left-buy"));
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.shift-right-sell"));
                } else if (item.canBuy()) {
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.left-click-buy"));
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.shift-left-buy"));
                } else if (item.canSell()) {
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.right-click-sell"));
                    itemBuilder.lore(this.plugin.getMessageManager().getMessage("gui.lore.shift-right-sell"));
                }
                if (item.getCustomModelData() > 0) {
                    itemBuilder.customModelData(item.getCustomModelData());
                }
                this.inventory.setItem(item.getSlot(), itemBuilder.build());
                this.clickableItems.put(item.getSlot(), item);
            }
        }
        this.addNavigationButtons();
        this.fillEmptySlots();
    }

    private void addNavigationButtons() {
        int totalPages = this.calculateTotalPages();
        boolean hasPrev = this.currentPage > 0;
        ItemBuilder prevButton = new ItemBuilder(this.plugin, hasPrev ? Material.ARROW : Material.BARRIER).name(hasPrev ? this.plugin.getMessageManager().getMessage("gui.navigation.previous") : this.plugin.getMessageManager().getMessage("gui.navigation.no-previous"));
        if (hasPrev) {
            prevButton.lore(this.plugin.getMessageManager().getMessage("gui.navigation.previous-lore").replace("<page>", String.valueOf(this.currentPage)));
        }
        this.inventory.setItem(45, prevButton.build());
        ItemBuilder pageInfo = new ItemBuilder(this.plugin, Material.PAPER).name(this.plugin.getMessageManager().getMessage("gui.navigation.page-info").replace("<current>", String.valueOf(this.currentPage + 1)).replace("<total>", String.valueOf(totalPages)));
        this.inventory.setItem(49, pageInfo.build());
        if (this.section != null) {
            ItemBuilder backButton = new ItemBuilder(this.plugin, Material.ARROW).name(this.plugin.getMessageManager().getMessage("gui.lore.back-title")).lore(this.plugin.getMessageManager().getMessage("gui.lore.back-button"));
            this.inventory.setItem(48, backButton.build());
        }
        if (this.section == null) {
            ItemBuilder searchItem = new ItemBuilder(this.plugin, Material.OAK_SIGN).name(this.plugin.getMessageManager().getMessage("gui.search.sign-title")).lore(this.plugin.getMessageManager().getMessage("gui.search.sign-lore"));
            this.inventory.setItem(51, searchItem.build());
        }
        boolean hasNext = this.currentPage < totalPages - 1;
        ItemBuilder nextButton = new ItemBuilder(this.plugin, hasNext ? Material.ARROW : Material.BARRIER).name(hasNext ? this.plugin.getMessageManager().getMessage("gui.navigation.next") : this.plugin.getMessageManager().getMessage("gui.navigation.no-next"));
        if (hasNext) {
            nextButton.lore(this.plugin.getMessageManager().getMessage("gui.navigation.next-lore").replace("<page>", String.valueOf(this.currentPage + 2)));
        }
        this.inventory.setItem(53, nextButton.build());
    }

    private int calculateTotalPages() {
        if (this.section == null) {
            return this.plugin.getShopManager().getSections().values().stream().mapToInt(ShopSection::getPage).max().orElse(0) + 1;
        }
        return this.section.getItems().stream().mapToInt(ShopItem::getPage).max().orElse(0) + 1;
    }

    private void fillEmptySlots() {
        ItemBuilder filler = new ItemBuilder(this.plugin, Material.GRAY_STAINED_GLASS_PANE).name(this.plugin.getMessageManager().getMessage("gui.lore.filler"));
        for (int i = 0; i < 45; ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, filler.build());
        }
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        int slot = event.getSlot();
        if (slot == 45) {
            if (this.currentPage > 0) {
                new ShopGUI(this.plugin, this.player, this.section, this.currentPage - 1).open();
            }
            return;
        }
        if (slot == 53) {
            int totalPages = this.calculateTotalPages();
            if (this.currentPage < totalPages - 1) {
                new ShopGUI(this.plugin, this.player, this.section, this.currentPage + 1).open();
            }
            return;
        }
        if (this.section == null && slot == 51) {
            this.player.closeInventory();
            this.plugin.getSignInputManager().openSearch(this.player, term -> {
                if (!term.isEmpty()) {
                    new SearchResultsGUI(this.plugin, this.player, (String)term).open();
                    this.player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)this.plugin.getMessageManager().getMessage("shop.search-starting").replace("<term>", (CharSequence)term)));
                }
            });
            return;
        }
        if (this.section != null && slot == 48) {
            new ShopGUI(this.plugin, this.player, null, 0).open();
            return;
        }
        if (this.section == null) {
            for (ShopSection shopSection : this.plugin.getShopManager().getSections().values()) {
                if (shopSection.getSlot() != slot || shopSection.getPage() != this.currentPage) continue;
                new ShopGUI(this.plugin, this.player, shopSection, 0).open();
                return;
            }
        } else {
            ShopItem item = this.clickableItems.get(slot);
            if (item != null) {
                this.handleItemClick(item, event);
            }
        }
    }

    private void handleItemClick(ShopItem item, InventoryClickEvent event) {
        boolean isBuy = event.isLeftClick();
        boolean isShift = event.isShiftClick();
        if (isBuy && isShift) {
            this.buyItem(item, 64);
        } else if (isBuy) {
            this.buyItem(item, 1);
        } else if (!isBuy && isShift) {
            this.sellItem(item, -1);
        } else {
            this.sellItem(item, 1);
        }
    }

    private void buyItem(ShopItem item, int quantity) {
        if (!item.canBuy()) {
            this.sendMessage("shop.cannot-buy");
            return;
        }
        StockManager stockManager = this.plugin.getStockManager();
        if (!stockManager.hasStock(item, quantity)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("current", String.valueOf(stockManager.getCurrentStock(item)));
            this.sendMessage("shop.not-enough-stock", placeholders);
            return;
        }
        double price = this.plugin.getDynamicPricingManager().getDynamicPrice(item, true) * (double)quantity;
        if (!this.plugin.getEconomyManager().hasEnough(this.player, price)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", NumberUtils.format(price));
            this.sendMessage("economy.not-enough-money", placeholders);
            return;
        }
        ItemStack itemStack = new ItemStack(item.getMaterial(), quantity);
        if (!this.player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
            this.sendMessage("shop.inventory-full");
            return;
        }
        if (!this.plugin.getEconomyManager().withdraw(this.player, price)) {
            this.player.getInventory().removeItem(new ItemStack[]{itemStack});
            this.sendMessage("economy.transaction-failed");
            return;
        }
        if (item.getStock() > 0) {
            stockManager.removeStock(item, quantity);
        }
        this.plugin.getDynamicPricingManager().recordTransaction(item, true, quantity);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(quantity));
        placeholders.put("item", NumberUtils.formatMaterialName(item.getMaterial()));
        placeholders.put("price", NumberUtils.format(price));
        this.sendMessage("shop.purchase-success", placeholders);
        this.playSound("buy");
        this.refreshGUI();
        this.plugin.getPlayerDataManager().recordTransaction(this.player, new Transaction(item.getMaterial(), quantity, price, true));
    }

    private void sellItem(ShopItem item, int quantity) {
        if (!item.canSell()) {
            this.sendMessage("shop.cannot-sell");
            return;
        }
        int itemCount = this.countItems(this.player, item.getMaterial());
        if (quantity == -1) {
            quantity = itemCount;
        }
        if (itemCount < quantity) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.valueOf(itemCount));
            this.sendMessage("shop.not-enough-items", placeholders);
            return;
        }
        double price = this.plugin.getDynamicPricingManager().getDynamicPrice(item, false) * (double)quantity;
        this.removeItems(this.player, item.getMaterial(), quantity);
        if (!this.plugin.getEconomyManager().deposit(this.player, price)) {
            this.player.getInventory().addItem(new ItemStack[]{new ItemStack(item.getMaterial(), quantity)});
            this.sendMessage("economy.transaction-failed");
            return;
        }
        if (item.getStock() > 0) {
            this.plugin.getStockManager().addStock(item, quantity);
        }
        this.plugin.getDynamicPricingManager().recordTransaction(item, false, quantity);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(quantity));
        placeholders.put("item", NumberUtils.formatMaterialName(item.getMaterial()));
        placeholders.put("price", NumberUtils.format(price));
        this.sendMessage("shop.sell-success", placeholders);
        this.playSound("sell");
        this.refreshGUI();
        this.plugin.getPlayerDataManager().recordTransaction(this.player, new Transaction(item.getMaterial(), quantity, price, false));
    }

    private void sendMessage(String key) {
        String msg = this.plugin.getMessageManager().getMessage(key);
        this.player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)msg));
    }

    private void sendMessage(String key, Map<String, String> placeholders) {
        String msg = this.plugin.getMessageManager().getMessage(key, placeholders);
        this.player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)msg));
    }

    private void playSound(String type) {
        if (!this.plugin.getConfig().getBoolean("gui.sound-effects.enabled", true)) {
            return;
        }
        String soundPath = "gui.sound-effects." + type;
        String sound = this.plugin.getConfig().getString(soundPath, "UI_BUTTON_CLICK");
        try {
            Sound soundEnum = Sound.valueOf((String)sound);
            this.player.playSound(this.player.getLocation(), soundEnum, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound: " + sound);
        }
    }

    private void refreshGUI() {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, this::open, 2L);
    }

    private int countItems(Player player, Material material) {
        return player.getInventory().all(material).values().stream().mapToInt(ItemStack::getAmount).sum();
    }

    private void removeItems(Player player, Material material, int quantity) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != material) continue;
            int amount = item.getAmount();
            if (amount > quantity) {
                item.setAmount(amount - quantity);
                break;
            }
            player.getInventory().remove(item);
            if ((quantity -= amount) == 0) break;
        }
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

