/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.libs.signgui;

import java.util.Arrays;
import net.godlycow.org.shopengine.libs.signgui.SignGUI;
import net.godlycow.org.shopengine.libs.signgui.SignGUIFinishHandler;
import org.apache.commons.lang.Validate;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;

public class SignGUIBuilder {
    private String[] lines = new String[4];
    private Object[] adventureLines = null;
    private Material type = SignGUI.WRAPPER.getDefaultType();
    private DyeColor color = DyeColor.BLACK;
    private boolean glow = false;
    private Location loc;
    private SignGUIFinishHandler handler;
    private boolean callHandlerSynchronously = false;
    private JavaPlugin plugin;

    SignGUIBuilder() {
    }

    public SignGUIBuilder setLines(String ... lines) {
        Validate.notNull((Object)lines, (String)"The lines cannot be null");
        this.lines = Arrays.copyOf(lines, 4);
        return this;
    }

    public SignGUIBuilder setLine(int index, String line) {
        Validate.isTrue((index >= 0 && index <= 3 ? 1 : 0) != 0, (String)"Index out of range");
        this.lines[index] = line;
        return this;
    }

    public SignGUIBuilder setAdventureLines(Object ... adventureLines) {
        Validate.notNull((Object)adventureLines, (String)"The adventure lines cannot be null");
        this.adventureLines = Arrays.copyOf(adventureLines, 4);
        return this;
    }

    public SignGUIBuilder setAdventureLine(int index, Object component) {
        Validate.isTrue((index >= 0 && index <= 3 ? 1 : 0) != 0, (String)"Index out of range");
        if (this.adventureLines == null) {
            this.adventureLines = new Object[4];
        }
        this.adventureLines[index] = component;
        return this;
    }

    public SignGUIBuilder setType(Material type) {
        Validate.notNull((Object)type, (String)"The type cannot be null");
        Validate.isTrue((boolean)SignGUI.WRAPPER.getSignTypes().contains(type), (String)(type + " is not a sign type. Available sign types: " + SignGUI.availableSignTypes));
        this.type = type;
        return this;
    }

    public SignGUIBuilder setColor(DyeColor color) {
        Validate.notNull((Object)color, (String)"The color cannot be null");
        this.color = color;
        return this;
    }

    public SignGUIBuilder setGlow(boolean glow) {
        this.glow = glow;
        return this;
    }

    public SignGUIBuilder setLocation(Location loc) {
        this.loc = loc;
        return this;
    }

    public SignGUIBuilder setHandler(SignGUIFinishHandler handler) {
        Validate.notNull((Object)handler, (String)"The handler cannot be null");
        this.handler = handler;
        return this;
    }

    public SignGUIBuilder callHandlerSynchronously(JavaPlugin plugin) {
        this.callHandlerSynchronously = true;
        this.plugin = plugin;
        return this;
    }

    public SignGUI build() {
        Validate.notNull((Object)this.handler, (String)"handler must be set");
        return new SignGUI(this.lines, this.adventureLines, this.type, this.color, this.glow, this.loc, this.handler, this.callHandlerSynchronously, this.plugin);
    }
}

