/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.godlycow.org.shopengine.ShopEngine;
import net.godlycow.org.shopengine.utils.MessageUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ShopEngine plugin;
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;
    private final List<Component> lore = new ArrayList<Component>();

    public ItemBuilder(ShopEngine plugin, Material material) {
        this.plugin = plugin;
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder name(String name) {
        this.itemMeta.displayName(MessageUtils.format(name));
        return this;
    }

    public ItemBuilder lore(String line) {
        this.lore.add(MessageUtils.format(line));
        return this;
    }

    public ItemBuilder lore(String ... lines) {
        Arrays.stream(lines).forEach(line -> this.lore.add(MessageUtils.format(line)));
        return this;
    }

    public ItemBuilder lore(List<String> lines) {
        lines.forEach(line -> this.lore.add(MessageUtils.format(line)));
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public ItemBuilder glow(boolean glow) {
        if (glow) {
            this.itemMeta.addEnchant(Enchantment.UNBREAKING, 1, true);
            this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return this;
    }

    public ItemBuilder customModelData(int data) {
        if (data > 0) {
            this.itemMeta.setCustomModelData(Integer.valueOf(data));
        }
        return this;
    }

    public ItemStack build() {
        if (!this.lore.isEmpty()) {
            this.itemMeta.lore(this.lore);
        }
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }
}

