/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.shopengine.utils;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.godlycow.org.shopengine.ShopEngine;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SignInputManager
implements Listener {
    private final ShopEngine plugin;
    private final Map<UUID, Consumer<String>> waitingPlayers = new HashMap<UUID, Consumer<String>>();

    public SignInputManager(ShopEngine plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openSearch(Player player, Consumer<String> callback) {
        this.waitingPlayers.put(player.getUniqueId(), callback);
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)this.plugin.getMessageManager().getMessage("shop.search-prompt")));
        player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)this.plugin.getMessageManager().getMessage("shop.search-cancel")));
    }

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        Consumer<String> callback = this.waitingPlayers.get(player.getUniqueId());
        if (callback == null) {
            return;
        }
        event.setCancelled(true);
        String message = PlainTextComponentSerializer.plainText().serialize(event.message()).trim();
        this.waitingPlayers.remove(player.getUniqueId());
        if (message.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.plugin.getMiniMessage().deserialize((Object)this.plugin.getMessageManager().getMessage("shop.search-cancelled")));
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(message));
    }

    public void cancelSearch(UUID playerId) {
        this.waitingPlayers.remove(playerId);
    }
}

