/*
 * Decompiled with CFR 0.152.
 */
package net.wesjd.anvilgui.version.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.wesjd.anvilgui.version.VersionWrapper;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class FallbackWrapper
implements VersionWrapper {
    private static final String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    private static final Class<?> playerClass;
    private static final Method playerGetHandle;
    private static final Method playerNextContainerCounter;
    private static final Class<?> craftEventFactory;
    private static final Method eventFactoryHandleInventoryCloseEvent;
    private static final Field playerPlayerConnection;
    private static final Class<?> playerConnectionClass;
    private static final Class<?> packetClass;
    private static final Method playerConnectionSendPacket;
    private static final Constructor<?> packetPlayOutOpenWindowConstructor;
    private static final Class<?> chatMessageClass;
    private static final Constructor<?> chatMessageConstructor;
    private static final String blockAnvilA;
    private static final Constructor<?> packetPlayOutCloseWindowConstructor;
    private static final Field playerActiveContainer;
    private static final Field playerDefaultContainer;
    private static final Field containerWindowId;
    private static final Method containerAddSlotListener;
    private static final Method containerGetBukkitView;
    private static final Field playerInventory;
    private static final Field playerWorld;
    private static final Object blockPositionZero;
    private static final Constructor<?> containerAnvilConstructor;
    private static final Field containerCheckReachable;

    @Override
    public int getNextContainerId(Player player) {
        try {
            return (Integer)playerNextContainerCounter.invoke(this.toNMS(player), new Object[0]);
        }
        catch (Exception e) {
            this.handleException(e);
            return -1;
        }
    }

    @Override
    public void handleInventoryCloseEvent(Player player) {
        try {
            eventFactoryHandleInventoryCloseEvent.invoke(craftEventFactory, this.toNMS(player));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void sendPacketOpenWindow(Player player, int containerId) {
        try {
            playerConnectionSendPacket.invoke(playerPlayerConnection.get(this.toNMS(player)), packetPlayOutOpenWindowConstructor.newInstance(containerId, "minecraft:anvil", chatMessageConstructor.newInstance(blockAnvilA + ".name", new Object[0])));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void sendPacketCloseWindow(Player player, int containerId) {
        try {
            playerConnectionSendPacket.invoke(playerPlayerConnection.get(this.toNMS(player)), packetPlayOutCloseWindowConstructor.newInstance(containerId));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setActiveContainerDefault(Player player) {
        try {
            Object nmsPlayer = this.toNMS(player);
            playerActiveContainer.set(nmsPlayer, playerDefaultContainer.get(nmsPlayer));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setActiveContainer(Player player, Object container) {
        try {
            playerActiveContainer.set(this.toNMS(player), container);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setActiveContainerId(Object container, int containerId) {
        try {
            containerWindowId.set(container, containerId);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void addActiveContainerSlotListener(Object container, Player player) {
        try {
            containerAddSlotListener.invoke(container, this.toNMS(player));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public Inventory toBukkitInventory(Object container) {
        try {
            return ((InventoryView)containerGetBukkitView.invoke(container, new Object[0])).getTopInventory();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Object newContainerAnvil(Player player) {
        try {
            Object nms = this.toNMS(player);
            Object obj = containerAnvilConstructor.newInstance(playerInventory.get(nms), playerWorld.get(nms), blockPositionZero, nms);
            containerCheckReachable.set(obj, false);
            return obj;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private Object toNMS(Player player) throws InvocationTargetException, IllegalAccessException {
        return playerGetHandle.invoke((Object)player, new Object[0]);
    }

    protected void handleException(Exception e) {
        throw new UnsupportedVersionException(version, e);
    }

    private static Class<?> getNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + version + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<?> getCraftClass(String path) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + version + "." + path);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            playerClass = FallbackWrapper.getNMSClass("EntityPlayer");
            playerGetHandle = FallbackWrapper.getCraftClass("entity.CraftPlayer").getMethod("getHandle", new Class[0]);
            playerNextContainerCounter = playerClass.getMethod("nextContainerCounter", new Class[0]);
            craftEventFactory = FallbackWrapper.getCraftClass("event.CraftEventFactory");
            eventFactoryHandleInventoryCloseEvent = craftEventFactory.getMethod("handleInventoryCloseEvent", FallbackWrapper.getNMSClass("EntityHuman"));
            playerPlayerConnection = playerClass.getField("playerConnection");
            playerConnectionClass = FallbackWrapper.getNMSClass("PlayerConnection");
            packetClass = FallbackWrapper.getNMSClass("Packet");
            playerConnectionSendPacket = playerConnectionClass.getMethod("sendPacket", packetClass);
            Class<?> packetPlayOutOpenWindowClass = FallbackWrapper.getNMSClass("PacketPlayOutOpenWindow");
            packetPlayOutOpenWindowConstructor = packetPlayOutOpenWindowClass.getConstructor(Integer.TYPE, String.class, FallbackWrapper.getNMSClass("IChatBaseComponent"));
            chatMessageClass = FallbackWrapper.getNMSClass("ChatMessage");
            chatMessageConstructor = chatMessageClass.getConstructor(String.class, Object[].class);
            Class<?> blockClass = FallbackWrapper.getNMSClass("Block");
            Method blockA = blockClass.getMethod("a", new Class[0]);
            Object blocksAnvil = FallbackWrapper.getNMSClass("Blocks").getField("ANVIL").get(null);
            blockAnvilA = (String)blockA.invoke(blocksAnvil, new Object[0]);
            Class<?> packetPlayOutCloseWindowClass = FallbackWrapper.getNMSClass("PacketPlayOutCloseWindow");
            packetPlayOutCloseWindowConstructor = packetPlayOutCloseWindowClass.getConstructor(Integer.TYPE);
            playerActiveContainer = playerClass.getField("activeContainer");
            playerDefaultContainer = playerClass.getField("defaultContainer");
            Class<?> containerClass = FallbackWrapper.getNMSClass("Container");
            containerWindowId = containerClass.getField("windowId");
            containerAddSlotListener = containerClass.getMethod("addSlotListener", FallbackWrapper.getNMSClass("ICrafting"));
            containerGetBukkitView = containerClass.getMethod("getBukkitView", new Class[0]);
            playerInventory = playerClass.getField("inventory");
            playerWorld = playerClass.getField("world");
            Class<?> blockPositionClass = FallbackWrapper.getNMSClass("BlockPosition");
            blockPositionZero = blockPositionClass.getField("ZERO").get(null);
            containerAnvilConstructor = FallbackWrapper.getNMSClass("ContainerAnvil").getConstructor(FallbackWrapper.getNMSClass("PlayerInventory"), FallbackWrapper.getNMSClass("World"), blockPositionClass, FallbackWrapper.getNMSClass("EntityHuman"));
            containerCheckReachable = FallbackWrapper.getNMSClass("Container").getField("checkReachable");
        }
        catch (Exception e) {
            throw new UnsupportedVersionException(version, e);
        }
    }

    public static class UnsupportedVersionException
    extends RuntimeException {
        private final String version;

        public UnsupportedVersionException(String version, Exception e) {
            super("Unsupported version \"" + version + "\", report this to the developers", e);
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

