/*
 * Decompiled with CFR 0.152.
 */
package com.flooferland.retrocrash;

import com.flooferland.retrocrash.RetroCrashMod;
import com.flooferland.retrocrash.util.ResLoc;
import com.flooferland.retrocrash.util.RetroCrashUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.minecraft.class_1041;
import net.minecraft.class_128;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public final class RetroCrashWindow {
    @Nullable
    static class_310 minecraft;
    @Nullable
    static class_128 report;
    @Nullable
    static JFrame frame;
    static String gameName;
    static String gameNameCapitalized;
    @Nullable
    static Throwable error;

    public static void prepare() {
        System.setProperty("java.awt.headless", "false");
        boolean isMinceraft = RetroCrashUtils.randomInt(0, 100) == 13;
        gameName = isMinceraft ? "minceraft" : "minecraft";
        gameNameCapitalized = gameName.substring(0, 1).toUpperCase() + gameName.substring(1);
    }

    static void run() {
        if (minecraft == null) {
            return;
        }
        if (report == null) {
            return;
        }
        class_1041 mc = minecraft.method_22683();
        frame = new JFrame("Minecraft");
        frame.setDefaultCloseOperation(2);
        frame.setSize(mc.method_4489(), mc.method_4506());
        frame.setLocation(mc.method_4499(), mc.method_4477());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBackground(new Color(46, 52, 68));
        mainPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        frame.setContentPane(mainPanel);
        JLabel logo = new JLabel();
        Image logoImage = RetroCrashWindow.getLogo();
        if (logoImage != null) {
            logo.setIconTextGap(0);
            logo.setText(null);
            logo.setIcon(new ImageIcon(logoImage));
        } else {
            logo.setText(gameName.toUpperCase());
            logo.setForeground(new Color(145, 145, 145));
            logo.setFont(new Font("Monospaced", 3, 64));
            logo.setHorizontalAlignment(0);
        }
        if (error != null) {
            RetroCrashMod.LOGGER.error(String.format("Unable to load %s's logo: ", gameNameCapitalized), error);
        }
        logo.setHorizontalAlignment(0);
        logo.setBorder(new EmptyBorder(15, 0, 0, 0));
        mainPanel.add((Component)logo, "North");
        JTextArea textArea = new JTextArea(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paintComponent(g);
            }
        };
        textArea.setText(RetroCrashUtils.getFriendlyReport(report));
        textArea.setFont(new Font("Monospaced", 1, 15));
        textArea.setForeground(Color.BLACK);
        textArea.setBackground(Color.WHITE);
        textArea.setEditable(false);
        textArea.setLineWrap(false);
        textArea.setMargin(new Insets(3, 3, 3, 3));
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(null);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.setBackground(new Color(46, 52, 68));
        content.setBorder(new EmptyBorder(10, 45, 125, 45));
        content.add((Component)scrollPane, "Center");
        mainPanel.add((Component)content, "Center");
        frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                Class<RetroCrashWindow> clazz = RetroCrashWindow.class;
                synchronized (RetroCrashWindow.class) {
                    RetroCrashWindow.class.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        frame.setVisible(true);
    }

    @Nullable
    static Image getLogo() {
        InputStream logo;
        if (minecraft == null) {
            return null;
        }
        class_3300 resources = minecraft.method_1478();
        class_2960 logoId = ResLoc.ofVanilla("textures/gui/title/" + gameName + ".png");
        try {
            logo = resources.method_14486(logoId).method_14482();
        }
        catch (IOException exception) {
            error = exception;
            return null;
        }
        if (logo == null) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(logo);
            try {
                image = RetroCrashWindow.mergeLogo(image);
            }
            catch (Exception throwable) {
                error = throwable;
                return null;
            }
            return image.getScaledInstance(310, 80, 4);
        }
        catch (IOException e) {
            error = e;
            return null;
        }
    }

    static BufferedImage mergeLogo(BufferedImage full) throws RasterFormatException, IllegalArgumentException {
        int partHeight = 45;
        int minecPartWidth = 154;
        int raftPartWidth = 118;
        int combinedWidth = 272;
        BufferedImage minecPart = full.getSubimage(0, 0, 154, 45);
        BufferedImage raftPart = full.getSubimage(0, 45, 118, 45);
        BufferedImage merged = new BufferedImage(272, 75, 2);
        Graphics2D graphics = merged.createGraphics();
        graphics.drawImage((Image)minecPart, 0, 0, null);
        graphics.drawImage((Image)raftPart, 154, 0, null);
        graphics.dispose();
        Image scaled = merged.getScaledInstance(1024, 256, 1);
        BufferedImage buffered = new BufferedImage(1024, 256, 2);
        buffered.createGraphics().drawImage(scaled, 0, 0, null);
        return buffered;
    }

    public static void spawn(class_310 minecraft, class_128 report) {
        RetroCrashWindow.minecraft = minecraft;
        RetroCrashWindow.report = report;
        RetroCrashWindow.prepare();
        RetroCrashMod.LOGGER.info("SPAWNING!");
        class_1041 window = minecraft.method_22683();
        long glfwWindow = window.method_4490();
        if (glfwWindow > 0L) {
            GLFW.glfwHideWindow((long)glfwWindow);
        }
        Thread thread = new Thread(() -> {
            try {
                SwingUtilities.invokeAndWait(RetroCrashWindow::run);
                Class<RetroCrashWindow> clazz = RetroCrashWindow.class;
                synchronized (RetroCrashWindow.class) {
                    RetroCrashWindow.class.wait();
                    // ** MonitorExit[var0] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                RetroCrashMod.LOGGER.error("Failed to show window", (Throwable)e);
            }
            {
                return;
            }
        }, "RetroCrash-Window");
        thread.setDaemon(false);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            RetroCrashMod.LOGGER.error("Failed to show window", (Throwable)e);
        }
    }
}

