/*
 * Decompiled with CFR 0.152.
 */
package com.flooferland.retrocrash;

import com.flooferland.retrocrash.RetroCrashMod;
import com.flooferland.retrocrash.util.BasedGson;
import com.google.gson.annotations.Expose;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public final class RetroCrashConfig {
    @Expose
    public boolean nativeLook = true;

    protected RetroCrashConfig() {
    }

    public void save() {
        try {
            Files.createDirectories(Companion.PATH.getParent(), new FileAttribute[0]);
            Files.writeString(Companion.PATH, (CharSequence)Companion.GSON.serialize(this), new OpenOption[0]);
        }
        catch (Exception e) {
            RetroCrashMod.LOGGER.error("Unable to save Retrocrash config", (Throwable)e);
        }
    }

    public static final class Companion {
        @NotNull
        public static final RetroCrashConfig DEFAULT = new RetroCrashConfig();
        @NotNull
        public static final Path PATH = class_310.method_1551().field_1697.toPath().resolve("config").resolve("retrocrash.json");
        @NotNull
        public static final BasedGson<RetroCrashConfig> GSON = new BasedGson<RetroCrashConfig>(RetroCrashConfig.class, "https://github.com/FlooferLand/retrocrash/wiki/Configuration");

        @NotNull
        public static RetroCrashConfig load() {
            try {
                BufferedReader reader = Files.newBufferedReader(PATH);
                return GSON.deserialize(reader);
            }
            catch (NoSuchFileException e) {
                Companion.saveDefault();
            }
            catch (IOException e) {
                RetroCrashMod.LOGGER.error("Unable to load Retrocrash config", (Throwable)e);
            }
            return new RetroCrashConfig();
        }

        public static void saveDefault() {
            new RetroCrashConfig().save();
        }
    }
}

