/*
 * Decompiled with CFR 0.152.
 */
package com.flooferland.retrocrash.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BasedGson<T> {
    protected Class<T> type;
    protected Gson internal = new GsonBuilder().serializeNulls().setLenient().disableJdkUnsafe().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    @Nullable
    protected String comment;

    public BasedGson(Class<T> classType, @Nullable String comment) {
        this.type = classType;
        this.comment = comment;
    }

    public T deserialize(Reader reader) throws JsonIOException, JsonSyntaxException {
        return (T)this.internal.fromJson(reader, this.type);
    }

    public String serialize(T data) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        jsonWriter.setIndent("\t");
        jsonWriter.setLenient(true);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setSerializeNulls(true);
        JsonObject built = this.internal.toJsonTree(data).getAsJsonObject();
        JsonObject object = new JsonObject();
        if (this.comment != null) {
            object.addProperty("comment", this.comment);
        }
        for (Map.Entry set : built.entrySet()) {
            object.add((String)set.getKey(), (JsonElement)set.getValue());
        }
        this.internal.toJson((JsonElement)object, jsonWriter);
        return writer.toString();
    }
}

