/*
 * Decompiled with CFR 0.152.
 */
package com.luminara.cfmgandcdgcombatability;

import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="cfmgandcdgcombatmod")
public class CFMGandCDGCombatability {
    public static final String MODID = "cfmgandcdgcombatmod";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CFMGandCDGCombatability(IEventBus modEventBus) {
        LOGGER.info("CFMG & CDG Compatibility Mod initializing!");
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("CFMG & CDG Common Setup starting...");
        LOGGER.info("Ensuring TFMG and CDG fluid tags are unified!");
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        LOGGER.info("Updating fluid tags for compatibility...");
        this.addFluidToTag("forge:diesel", "tfmg:diesel");
        this.addFluidToTag("forge:diesel", "createdieselgenerators:diesel");
        this.addFluidToTag("c:fuel", "createdieselgenerators:diesel");
        this.addFluidToTag("tfmg:flammable", "createdieselgenerators:diesel");
        this.addFluidToTag("tfmg:firebox_fuel", "createdieselgenerators:diesel");
        this.addFluidToTag("forge:gasoline", "tfmg:gasoline");
        this.addFluidToTag("tfmg:gasoline", "createdieselgenerators:gasoline");
        this.addFluidToTag("forge:gasoline", "createdieselgenerators:gasoline");
        this.addFluidToTag("c:fuel", "createdieselgenerators:gasoline");
        this.addFluidToTag("tfmg:flammable", "createdieselgenerators:gasoline");
        LOGGER.info("Fluid tag unification complete!");
    }

    private void addFluidToTag(String tagName, String fluidId) {
        try {
            ResourceLocation fluidLocation = ResourceLocation.tryParse((String)fluidId);
            if (fluidLocation != null) {
                Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidLocation);
                if (fluid != Fluids.EMPTY) {
                    LOGGER.info("Adding {} to tag {}", (Object)fluidId, (Object)tagName);
                } else {
                    LOGGER.warn("Could not find fluid: {}", (Object)fluidId);
                }
            } else {
                LOGGER.warn("Invalid ResourceLocation string: {}", (Object)fluidId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to add fluid {} to tag {}", new Object[]{fluidId, tagName, e});
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Server starting with CFMG & CDG compatibility active!");
    }
}

