/*
 * Decompiled with CFR 0.152.
 */
package de.erikd.lite2edit;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lde/erikd/lite2edit/NBTHelper;", "", "<init>", "()V", "Ljava/io/InputStream;", "input", "Lnet/kyori/adventure/nbt/CompoundBinaryTag;", "loadLitematic", "(Ljava/io/InputStream;)Lnet/kyori/adventure/nbt/CompoundBinaryTag;", "lite2edit"})
public final class NBTHelper {
    @NotNull
    public static final NBTHelper INSTANCE = new NBTHelper();

    private NBTHelper() {
    }

    @NotNull
    public final CompoundBinaryTag loadLitematic(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BufferedInputStream buffered = new BufferedInputStream(input, 65536);
        PushbackInputStream pb = new PushbackInputStream(buffered, 4);
        try {
            byte[] sig = new byte[2];
            int n = pb.read(sig);
            if (n > 0) {
                pb.unread(sig, 0, n);
            }
            boolean gz = n == 2 && sig[0] == 31 && sig[1] == -117;
            InputStream decoded = gz ? (InputStream)new GZIPInputStream(pb) : (InputStream)pb;
            CompoundBinaryTag compoundBinaryTag = BinaryTagIO.unlimitedReader().read(decoded);
            Intrinsics.checkNotNullExpressionValue((Object)compoundBinaryTag, (String)"read(...)");
            BinaryTag tag = (BinaryTag)compoundBinaryTag;
            CompoundBinaryTag compoundBinaryTag2 = (CompoundBinaryTag)tag;
            if (compoundBinaryTag2 == null) {
                throw new IllegalArgumentException("Root tag is not a CompoundBinaryTag");
            }
            CompoundBinaryTag root = compoundBinaryTag2;
            return root;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to read Litematic NBT: " + t.getMessage(), t);
        }
    }
}

