/*
 * Decompiled with CFR 0.152.
 */
package de.erikd.lite2edit;

import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import de.erikd.lite2edit.BlockHelper;
import de.erikd.lite2edit.LitematicaSchematic;
import de.erikd.lite2edit.TileEntityHelper;
import de.erikd.lite2edit.util.NBTHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\r\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJC\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lde/erikd/lite2edit/ReadConverter;", "", "<init>", "()V", "Ljava/io/InputStream;", "inputStream", "Lcom/sk89q/worldedit/extent/clipboard/Clipboard;", "read", "(Ljava/io/InputStream;)Lcom/sk89q/worldedit/extent/clipboard/Clipboard;", "", "", "Lde/erikd/lite2edit/LitematicaSchematic$Region;", "regions", "convertRegions", "(Ljava/util/Map;)Lcom/sk89q/worldedit/extent/clipboard/Clipboard;", "region", "Lcom/sk89q/worldedit/extent/clipboard/BlockArrayClipboard;", "clipboard", "", "offsetX", "offsetY", "offsetZ", "Lkotlin/Pair;", "convertRegion", "(Lde/erikd/lite2edit/LitematicaSchematic$Region;Lcom/sk89q/worldedit/extent/clipboard/BlockArrayClipboard;III)Lkotlin/Pair;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lite2Edit"})
@SourceDebugExtension(value={"SMAP\nReadConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadConverter.kt\nde/erikd/lite2edit/ReadConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1869#2,2:173\n1869#2,2:175\n1563#2:177\n1634#2,3:178\n*S KotlinDebug\n*F\n+ 1 ReadConverter.kt\nde/erikd/lite2edit/ReadConverter\n*L\n51#1:173,2\n87#1:175,2\n110#1:177\n110#1:178,3\n*E\n"})
public final class ReadConverter {
    @NotNull
    public static final ReadConverter INSTANCE = new ReadConverter();
    private static final Logger logger = LoggerFactory.getLogger(ReadConverter.class);

    private ReadConverter() {
    }

    @NotNull
    public final Clipboard read(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        CompoundBinaryTag root = NBTHelper.INSTANCE.loadLitematic(inputStream);
        LitematicaSchematic schematic = new LitematicaSchematic(root);
        if (schematic.getRegions().isEmpty()) {
            throw new IllegalStateException("No regions found in schematic");
        }
        return this.convertRegions(schematic.getRegions());
    }

    private final Clipboard convertRegions(Map<String, LitematicaSchematic.Region> regions) {
        if (regions.size() == 1) {
            LitematicaSchematic.Region region = (LitematicaSchematic.Region)CollectionsKt.first((Iterable)regions.values());
            int sizeX = Math.abs(region.getSize().getX());
            int sizeY = Math.abs(region.getSize().getY());
            int sizeZ = Math.abs(region.getSize().getZ());
            LitematicaSchematic.Vec3 offset = region.getOffset();
            CuboidRegion clipboardRegion = new CuboidRegion(BlockVector3.ZERO, BlockVector3.at((int)(sizeX - 1), (int)(sizeY - 1), (int)(sizeZ - 1)));
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)clipboardRegion);
            clipboard.setOrigin(BlockVector3.at((int)offset.getX(), (int)offset.getY(), (int)offset.getZ()));
            Pair<Integer, Integer> pair = this.convertRegion(region, clipboard, 0, 0, 0);
            int blocksSet = ((Number)pair.component1()).intValue();
            int tileEntitiesSet = ((Number)pair.component2()).intValue();
            logger.info("Converted single Litematica region sized " + sizeX + "x" + sizeY + "x" + sizeZ + ", set " + blocksSet + " blocks and " + tileEntitiesSet + " tile entities");
            return (Clipboard)clipboard;
        }
        int minX = 0;
        minX = Integer.MAX_VALUE;
        int minY = 0;
        minY = Integer.MAX_VALUE;
        int minZ = 0;
        minZ = Integer.MAX_VALUE;
        int maxX = 0;
        maxX = Integer.MIN_VALUE;
        int maxY = 0;
        maxY = Integer.MIN_VALUE;
        int maxZ = 0;
        maxZ = Integer.MIN_VALUE;
        Iterable $this$forEach$iv = regions.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LitematicaSchematic.Region region = (LitematicaSchematic.Region)element$iv;
            boolean bl = false;
            LitematicaSchematic.Vec3 offset = region.getOffset();
            int sizeX = region.getSize().getX();
            int sizeY = region.getSize().getY();
            int sizeZ = region.getSize().getZ();
            int regionMinX = offset.getX();
            int regionMinY = offset.getY();
            int regionMinZ = offset.getZ();
            int regionMaxX = offset.getX() + (sizeX >= 0 ? sizeX - 1 : sizeX + 1);
            int regionMaxY = offset.getY() + (sizeY >= 0 ? sizeY - 1 : sizeY + 1);
            int regionMaxZ = offset.getZ() + (sizeZ >= 0 ? sizeZ - 1 : sizeZ + 1);
            minX = Math.min(minX, regionMinX);
            minY = Math.min(minY, regionMinY);
            minZ = Math.min(minZ, regionMinZ);
            maxX = Math.max(maxX, regionMaxX);
            maxY = Math.max(maxY, regionMaxY);
            maxZ = Math.max(maxZ, regionMaxZ);
        }
        int totalWidth = maxX - minX + 1;
        int totalHeight = maxY - minY + 1;
        int totalLength = maxZ - minZ + 1;
        CuboidRegion clipboardRegion = new CuboidRegion(BlockVector3.ZERO, BlockVector3.at((int)(totalWidth - 1), (int)(totalHeight - 1), (int)(totalLength - 1)));
        BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)clipboardRegion);
        clipboard.setOrigin(BlockVector3.at((int)minX, (int)minY, (int)minZ));
        int totalBlocksSet = 0;
        int totalTileEntitiesSet = 0;
        Iterable $this$forEach$iv2 = regions.values();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            LitematicaSchematic.Region region = (LitematicaSchematic.Region)element$iv;
            boolean bl = false;
            LitematicaSchematic.Vec3 offset = region.getOffset();
            int relX = offset.getX() - minX;
            int relY = offset.getY() - minY;
            int relZ = offset.getZ() - minZ;
            Pair<Integer, Integer> pair = INSTANCE.convertRegion(region, clipboard, relX, relY, relZ);
            int blocksSet = ((Number)pair.component1()).intValue();
            int tileEntitiesSet = ((Number)pair.component2()).intValue();
            totalBlocksSet += blocksSet;
            totalTileEntitiesSet += tileEntitiesSet;
        }
        logger.info("Converted multiple Litematica regions sized " + totalWidth + "x" + totalHeight + "x" + totalLength + ", set " + totalBlocksSet + " blocks and " + totalTileEntitiesSet + " tile entities");
        return (Clipboard)clipboard;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Integer> convertRegion(LitematicaSchematic.Region region, BlockArrayClipboard clipboard, int offsetX, int offsetY, int offsetZ) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = region.getBlockStatePalette();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            LitematicaSchematic.Region.BlockStateEntry blockStateEntry = (LitematicaSchematic.Region.BlockStateEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BlockHelper.INSTANCE.parseBlockState(entry.getName(), entry.getProperties()));
        }
        List palette = (List)destination$iv$iv;
        Map<String, CompoundBinaryTag> tileEntityMap = TileEntityHelper.INSTANCE.createTileEntityMap(region.getTileEntities());
        int blocksSet = 0;
        int tileEntitiesSet = 0;
        for (LitematicaSchematic.Region.Quad quad : region.blocksWithCoordinates()) {
            int x = quad.getX();
            int y = quad.getY();
            int z = quad.getZ();
            int paletteIndex = quad.getPaletteIndex();
            boolean bl = 0 <= paletteIndex ? paletteIndex < ((Collection)palette).size() : false;
            if (bl) {
                BlockState blockState = (BlockState)palette.get(paletteIndex);
                if (blockState != null) {
                    try {
                        int worldX = offsetX + x;
                        int worldY = offsetY + y;
                        int worldZ = offsetZ + z;
                        BlockVector3 position = BlockVector3.at((int)worldX, (int)worldY, (int)worldZ);
                        CompoundBinaryTag tileEntityNbt = tileEntityMap.get(TileEntityHelper.INSTANCE.positionKey(x, y, z));
                        BaseBlock baseBlock = TileEntityHelper.INSTANCE.createBaseBlock(blockState, tileEntityNbt);
                        clipboard.setBlock(position, (BlockStateHolder)baseBlock);
                        ++blocksSet;
                        if (tileEntityNbt == null) continue;
                        ++tileEntitiesSet;
                    }
                    catch (Exception e) {
                        logger.error("Failed to set block at (" + (offsetX + x) + ", " + (offsetY + y) + ", " + (offsetZ + z) + ") " + blockState.getAsString(), (Throwable)e);
                    }
                    continue;
                }
                logger.warn("Null block state for palette index " + paletteIndex);
                continue;
            }
            logger.warn("Invalid palette index " + paletteIndex + " (palette size " + palette.size() + ")");
        }
        return new Pair((Object)blocksSet, (Object)tileEntitiesSet);
    }
}

