/*
 * Decompiled with CFR 0.152.
 */
package de.erikd.lite2edit;

import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinIntTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001c\u0010\"\u001a\n !*\u0004\u0018\u00010 0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lde/erikd/lite2edit/TileEntityHelper;", "", "<init>", "()V", "Lcom/sk89q/worldedit/world/block/BlockState;", "blockState", "Lnet/kyori/adventure/nbt/CompoundBinaryTag;", "tileEntityNbt", "Lcom/sk89q/worldedit/world/block/BaseBlock;", "createBaseBlock", "(Lcom/sk89q/worldedit/world/block/BlockState;Lnet/kyori/adventure/nbt/CompoundBinaryTag;)Lcom/sk89q/worldedit/world/block/BaseBlock;", "nbt", "Lorg/enginehub/linbus/tree/LinCompoundTag;", "convertNbtToLinBus", "(Lnet/kyori/adventure/nbt/CompoundBinaryTag;)Lorg/enginehub/linbus/tree/LinCompoundTag;", "Lnet/kyori/adventure/nbt/ListBinaryTag;", "list", "Lorg/enginehub/linbus/tree/LinListTag;", "convertNbtListToLinBus", "(Lnet/kyori/adventure/nbt/ListBinaryTag;)Lorg/enginehub/linbus/tree/LinListTag;", "", "tileEntities", "", "", "createTileEntityMap", "(Ljava/util/List;)Ljava/util/Map;", "", "x", "y", "z", "positionKey", "(III)Ljava/lang/String;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lite2Edit"})
@SourceDebugExtension(value={"SMAP\nTileEntityHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileEntityHelper.kt\nde/erikd/lite2edit/TileEntityHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1208#2,2:99\n1236#2,4:101\n*S KotlinDebug\n*F\n+ 1 TileEntityHelper.kt\nde/erikd/lite2edit/TileEntityHelper\n*L\n91#1:99,2\n91#1:101,4\n*E\n"})
public final class TileEntityHelper {
    @NotNull
    public static final TileEntityHelper INSTANCE = new TileEntityHelper();
    private static final Logger logger = LoggerFactory.getLogger(TileEntityHelper.class);

    private TileEntityHelper() {
    }

    @NotNull
    public final BaseBlock createBaseBlock(@NotNull BlockState blockState, @Nullable CompoundBinaryTag tileEntityNbt) {
        BaseBlock baseBlock;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (tileEntityNbt == null) {
            BaseBlock baseBlock2 = blockState.toBaseBlock();
            Intrinsics.checkNotNull((Object)baseBlock2);
            baseBlock = baseBlock2;
        } else {
            LinCompoundTag linNbt = this.convertNbtToLinBus(tileEntityNbt);
            BaseBlock baseBlock3 = blockState.toBaseBlock(linNbt);
            Intrinsics.checkNotNull((Object)baseBlock3);
            baseBlock = baseBlock3;
        }
        return baseBlock;
    }

    private final LinCompoundTag convertNbtToLinBus(CompoundBinaryTag nbt) {
        LinCompoundTag.Builder builder = LinCompoundTag.builder();
        for (String key : nbt.keySet()) {
            try {
                LinCompoundTag.Builder builder2;
                BinaryTag tag = nbt.get(key);
                if (tag instanceof ByteBinaryTag) {
                    LinCompoundTag.Builder builder3 = builder.putByte(key, ((ByteBinaryTag)tag).value());
                    builder2 = builder3;
                    Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"putByte(...)");
                    continue;
                }
                if (tag instanceof ShortBinaryTag) {
                    LinCompoundTag.Builder builder4 = builder.putShort(key, ((ShortBinaryTag)tag).value());
                    builder2 = builder4;
                    Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"putShort(...)");
                    continue;
                }
                if (tag instanceof IntBinaryTag) {
                    LinCompoundTag.Builder builder5 = builder.putInt(key, ((IntBinaryTag)tag).value());
                    builder2 = builder5;
                    Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"putInt(...)");
                    continue;
                }
                if (tag instanceof LongBinaryTag) {
                    LinCompoundTag.Builder builder6 = builder.putLong(key, ((LongBinaryTag)tag).value());
                    builder2 = builder6;
                    Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"putLong(...)");
                    continue;
                }
                if (tag instanceof FloatBinaryTag) {
                    LinCompoundTag.Builder builder7 = builder.putFloat(key, ((FloatBinaryTag)tag).value());
                    builder2 = builder7;
                    Intrinsics.checkNotNullExpressionValue((Object)builder7, (String)"putFloat(...)");
                    continue;
                }
                if (tag instanceof DoubleBinaryTag) {
                    LinCompoundTag.Builder builder8 = builder.putDouble(key, ((DoubleBinaryTag)tag).value());
                    builder2 = builder8;
                    Intrinsics.checkNotNullExpressionValue((Object)builder8, (String)"putDouble(...)");
                    continue;
                }
                if (tag instanceof StringBinaryTag) {
                    LinCompoundTag.Builder builder9 = builder.putString(key, ((StringBinaryTag)tag).value());
                    builder2 = builder9;
                    Intrinsics.checkNotNullExpressionValue((Object)builder9, (String)"putString(...)");
                    continue;
                }
                if (tag instanceof ByteArrayBinaryTag) {
                    LinCompoundTag.Builder builder10 = builder.putByteArray(key, ((ByteArrayBinaryTag)tag).value());
                    builder2 = builder10;
                    Intrinsics.checkNotNullExpressionValue((Object)builder10, (String)"putByteArray(...)");
                    continue;
                }
                if (tag instanceof IntArrayBinaryTag) {
                    LinCompoundTag.Builder builder11 = builder.putIntArray(key, ((IntArrayBinaryTag)tag).value());
                    builder2 = builder11;
                    Intrinsics.checkNotNullExpressionValue((Object)builder11, (String)"putIntArray(...)");
                    continue;
                }
                if (tag instanceof LongArrayBinaryTag) {
                    LinCompoundTag.Builder builder12 = builder.putLongArray(key, ((LongArrayBinaryTag)tag).value());
                    builder2 = builder12;
                    Intrinsics.checkNotNullExpressionValue((Object)builder12, (String)"putLongArray(...)");
                    continue;
                }
                if (tag instanceof CompoundBinaryTag) {
                    LinCompoundTag.Builder builder13 = builder.put(key, (LinTag)this.convertNbtToLinBus((CompoundBinaryTag)tag));
                    builder2 = builder13;
                    Intrinsics.checkNotNullExpressionValue((Object)builder13, (String)"put(...)");
                    continue;
                }
                if (tag instanceof ListBinaryTag) {
                    LinCompoundTag.Builder builder14 = builder.put(key, (LinTag)this.convertNbtListToLinBus((ListBinaryTag)tag));
                    builder2 = builder14;
                    Intrinsics.checkNotNullExpressionValue((Object)builder14, (String)"put(...)");
                    continue;
                }
                BinaryTag binaryTag = tag;
                logger.warn("Unsupported NBT tag type for key " + key + ": " + (binaryTag != null && (binaryTag = binaryTag.type()) != null ? binaryTag.toString() : null));
                builder2 = Unit.INSTANCE;
            }
            catch (Exception e) {
                logger.error("Failed to convert NBT tag '" + key + "': " + e.getMessage(), (Throwable)e);
            }
        }
        LinCompoundTag linCompoundTag = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)linCompoundTag, (String)"build(...)");
        return linCompoundTag;
    }

    private final LinListTag<?> convertNbtListToLinBus(ListBinaryTag list) {
        LinListTag linListTag;
        if (list.isEmpty()) {
            LinListTag linListTag2 = LinListTag.builder((LinTagType)LinTagType.compoundTag()).build();
            Intrinsics.checkNotNullExpressionValue((Object)linListTag2, (String)"build(...)");
            return linListTag2;
        }
        BinaryTagType binaryTagType = list.elementType();
        if (Intrinsics.areEqual((Object)binaryTagType, (Object)BinaryTagTypes.COMPOUND)) {
            LinListTag.Builder builder = LinListTag.builder((LinTagType)LinTagType.compoundTag());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            LinListTag.Builder b = builder;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CompoundBinaryTag compoundBinaryTag = list.getCompound(i);
                Intrinsics.checkNotNullExpressionValue((Object)compoundBinaryTag, (String)"getCompound(...)");
                b.add((LinTag)this.convertNbtToLinBus(compoundBinaryTag));
            }
            LinListTag linListTag3 = b.build();
            Intrinsics.checkNotNull((Object)linListTag3);
            linListTag = linListTag3;
        } else if (Intrinsics.areEqual((Object)binaryTagType, (Object)BinaryTagTypes.STRING)) {
            LinListTag.Builder builder = LinListTag.builder((LinTagType)LinTagType.stringTag());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            LinListTag.Builder b = builder;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                b.add((LinTag)LinStringTag.of((String)list.getString(i)));
            }
            LinListTag linListTag4 = b.build();
            Intrinsics.checkNotNull((Object)linListTag4);
            linListTag = linListTag4;
        } else if (Intrinsics.areEqual((Object)binaryTagType, (Object)BinaryTagTypes.INT)) {
            LinListTag.Builder builder = LinListTag.builder((LinTagType)LinTagType.intTag());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            LinListTag.Builder b = builder;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                b.add((LinTag)LinIntTag.of((int)list.getInt(i)));
            }
            LinListTag linListTag5 = b.build();
            Intrinsics.checkNotNull((Object)linListTag5);
            linListTag = linListTag5;
        } else {
            logger.warn("Unsupported list element type: " + list.elementType());
            LinListTag linListTag6 = LinListTag.builder((LinTagType)LinTagType.compoundTag()).build();
            Intrinsics.checkNotNull((Object)linListTag6);
            linListTag = linListTag6;
        }
        return linListTag;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, CompoundBinaryTag> createTileEntityMap(@NotNull List<? extends CompoundBinaryTag> tileEntities) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tileEntities, (String)"tileEntities");
        Iterable $this$associateBy$iv = tileEntities;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void nbt;
            CompoundBinaryTag compoundBinaryTag = (CompoundBinaryTag)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(INSTANCE.positionKey(nbt.getInt("x"), nbt.getInt("y"), nbt.getInt("z")), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final String positionKey(int x, int y, int z) {
        return x + "," + y + "," + z;
    }
}

