/*
 * Decompiled with CFR 0.152.
 */
package com.chatz.booktypesenchanting;

import com.chatz.booktypesenchanting.EnchantmentBookType;
import com.chatz.booktypesenchanting.TypeBookItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="booktypesenchanting")
public class EnchantingEventHandler {
    private static final Map<UUID, EnchantmentBookType> playerTypeBooks = new HashMap<UUID, EnchantmentBookType>();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        if (event.getLevel().getBlockState(pos).getBlock() instanceof EnchantingTableBlock) {
            ItemStack heldItem = event.getItemStack();
            Item item = heldItem.getItem();
            if (item instanceof TypeBookItem) {
                TypeBookItem typeBook = (TypeBookItem)item;
                playerTypeBooks.put(player.getUUID(), typeBook.getBookType());
                if (!player.isCreative()) {
                    heldItem.shrink(1);
                }
            } else {
                playerTypeBooks.remove(player.getUUID());
            }
        }
    }

    public static EnchantmentBookType getPlayerTypeBook(UUID playerUUID) {
        return playerTypeBooks.get(playerUUID);
    }

    public static void clearPlayerTypeBook(UUID playerUUID) {
        playerTypeBooks.remove(playerUUID);
    }
}

