/*
 * Decompiled with CFR 0.152.
 */
package com.chatz.booktypesenchanting;

import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;

public enum EnchantmentBookType {
    SWORD("sword", item -> item instanceof SwordItem),
    PICKAXE("pickaxe", item -> item instanceof PickaxeItem),
    AXE("axe", item -> item instanceof AxeItem),
    SHOVEL("shovel", item -> item instanceof ShovelItem),
    HOE("hoe", item -> item instanceof HoeItem),
    HELMET("helmet", item -> item instanceof ArmorItem && ((ArmorItem)item).getType() == ArmorItem.Type.HELMET),
    CHESTPLATE("chestplate", item -> item instanceof ArmorItem && ((ArmorItem)item).getType() == ArmorItem.Type.CHESTPLATE),
    LEGGINGS("leggings", item -> item instanceof ArmorItem && ((ArmorItem)item).getType() == ArmorItem.Type.LEGGINGS),
    BOOTS("boots", item -> item instanceof ArmorItem && ((ArmorItem)item).getType() == ArmorItem.Type.BOOTS),
    BOW("bow", item -> item instanceof BowItem),
    CROSSBOW("crossbow", item -> item instanceof CrossbowItem),
    TRIDENT("trident", item -> item instanceof TridentItem),
    FISHING_ROD("fishing_rod", item -> item instanceof FishingRodItem);

    private final String name;
    private final ItemPredicate predicate;

    private EnchantmentBookType(String name, ItemPredicate predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(Item item) {
        return this.predicate.test(item);
    }

    @FunctionalInterface
    public static interface ItemPredicate {
        public boolean test(Item var1);
    }
}

