/*
 * Decompiled with CFR 0.152.
 */
package com.chatz.booktypesenchanting;

import com.chatz.booktypesenchanting.EnchantmentBookType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class TypeBookItem
extends Item {
    private final EnchantmentBookType bookType;

    public TypeBookItem(EnchantmentBookType bookType) {
        super(new Item.Properties().stacksTo(64));
        this.bookType = bookType;
    }

    public EnchantmentBookType getBookType() {
        return this.bookType;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().forEach(entry -> tooltipComponents.add((Component)Component.translatable((String)((Enchantment)((Holder)entry.getKey()).value()).description().getString()).withStyle(ChatFormatting.GRAY)));
        if (EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.booktypesenchanting.type_book", (Object[])new Object[]{Component.translatable((String)("item.booktypesenchanting." + this.bookType.getName() + "_book.type"))}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.booktypesenchanting.type_book.usage").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 15;
    }
}

