/*
 * Decompiled with CFR 0.152.
 */
package com.chatz.booktypesenchanting.mixin;

import com.chatz.booktypesenchanting.EnchantmentBookType;
import com.chatz.booktypesenchanting.TypeBookItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentMenu.class})
public abstract class EnchantmentMenuMixin {
    @Unique
    private ItemStack booktypesenchanting$originalStack;

    @ModifyVariable(method={"getEnchantmentList"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private ItemStack booktypesenchanting$replaceStackForEnchanting(ItemStack stack) {
        this.booktypesenchanting$originalStack = stack;
        Item item = stack.getItem();
        if (item instanceof TypeBookItem) {
            TypeBookItem typeBook = (TypeBookItem)item;
            EnchantmentBookType bookType = typeBook.getBookType();
            ItemStack replacementStack = switch (bookType) {
                default -> throw new MatchException(null, null);
                case EnchantmentBookType.SWORD -> new ItemStack((ItemLike)Items.DIAMOND_SWORD);
                case EnchantmentBookType.PICKAXE -> new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
                case EnchantmentBookType.AXE -> new ItemStack((ItemLike)Items.DIAMOND_AXE);
                case EnchantmentBookType.SHOVEL -> new ItemStack((ItemLike)Items.DIAMOND_SHOVEL);
                case EnchantmentBookType.HOE -> new ItemStack((ItemLike)Items.DIAMOND_HOE);
                case EnchantmentBookType.HELMET -> new ItemStack((ItemLike)Items.DIAMOND_HELMET);
                case EnchantmentBookType.CHESTPLATE -> new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE);
                case EnchantmentBookType.LEGGINGS -> new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS);
                case EnchantmentBookType.BOOTS -> new ItemStack((ItemLike)Items.DIAMOND_BOOTS);
                case EnchantmentBookType.BOW -> new ItemStack((ItemLike)Items.BOW);
                case EnchantmentBookType.CROSSBOW -> new ItemStack((ItemLike)Items.CROSSBOW);
                case EnchantmentBookType.TRIDENT -> new ItemStack((ItemLike)Items.TRIDENT);
                case EnchantmentBookType.FISHING_ROD -> new ItemStack((ItemLike)Items.FISHING_ROD);
            };
            replacementStack.setCount(1);
            return replacementStack;
        }
        return stack;
    }

    @Inject(method={"clickMenuButton"}, at={@At(value="RETURN")})
    private void booktypesenchanting$convertToEnchantedBook(Player player, int id, CallbackInfoReturnable<Boolean> cir) {
        EnchantmentMenu menu;
        ItemStack stack;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (stack = (menu = (EnchantmentMenu)this).getSlot(0).getItem()).getItem() instanceof TypeBookItem) {
            ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            enchantedBook.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments);
            menu.getSlot(0).set(enchantedBook);
        }
    }
}

