/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.priorityqueue;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PriorityQueue
extends JavaPlugin
implements Listener {
    private int maxPlayers;
    private String priorityPermission;
    private String kickMessage;
    private String priorityMessage;
    private String noPermissionMessage;
    private List<String> exemptPlayers;
    private boolean debug;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("priorityqueue").setExecutor(this);
        this.getLogger().info("PriorityQueue has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("PriorityQueue has been disabled!");
    }

    private void loadConfiguration() {
        FileConfiguration config = this.getConfig();
        this.reloadConfig();
        this.maxPlayers = config.getInt("settings.max-players", 100);
        this.priorityPermission = config.getString("settings.priority-permission", "priorityqueue.priority");
        this.kickMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.kick-message", "&cThe server is full! A priority player has joined."));
        this.priorityMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.priority-join-message", "&aYou have joined using your priority access."));
        this.noPermissionMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.no-permission", "&cYou do not have permission to use this command."));
        this.exemptPlayers = config.getStringList("settings.exempt-players");
        this.debug = config.getBoolean("settings.debug", false);
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        if (onlinePlayers < this.maxPlayers) {
            if (player.hasPermission(this.priorityPermission) && this.debug) {
                this.getLogger().info("Server not full. Player " + player.getName() + " joining normally (has priority).");
            }
            return;
        }
        if (player.hasPermission(this.priorityPermission)) {
            Player playerToKick;
            if (this.debug) {
                this.getLogger().info("Server full. Priority player " + player.getName() + " attempting to join.");
            }
            if ((playerToKick = this.findPlayerToKick()) != null) {
                playerToKick.kickPlayer(this.kickMessage);
                event.allow();
                String playerName = player.getName();
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                    Player p = Bukkit.getPlayer(playerName);
                    if (p != null && p.isOnline()) {
                        p.sendMessage(this.priorityMessage);
                    }
                }, 20L);
                if (this.debug) {
                    this.getLogger().info("Kicked " + playerToKick.getName() + " to make room for priority player " + player.getName());
                }
            } else if (this.debug) {
                this.getLogger().info("No suitable player found to kick for priority player " + player.getName());
            }
        }
    }

    private Player findPlayerToKick() {
        ArrayList<Player> kickCandidates = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.hasPermission(this.priorityPermission) || this.exemptPlayers.contains(player.getName()) || player.isOp()) continue;
            kickCandidates.add(player);
        }
        if (kickCandidates.isEmpty()) {
            return null;
        }
        Random random = new Random();
        return (Player)kickCandidates.get(random.nextInt(kickCandidates.size()));
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("priorityqueue")) {
            if (args.length == 0) {
                sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "PriorityQueue " + this.getDescription().getVersion());
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Use /priorityqueue reload to reload the configuration.");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("priorityqueue.admin")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                this.loadConfiguration();
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "PriorityQueue configuration reloaded!");
                return true;
            }
            if (args[0].equalsIgnoreCase("status")) {
                if (!sender.hasPermission("priorityqueue.admin")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "PriorityQueue Status:");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Online Players: " + Bukkit.getOnlinePlayers().size() + "/" + this.maxPlayers);
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Priority Permission: " + this.priorityPermission);
                return true;
            }
        }
        return false;
    }
}

